/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.transferimports;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.external.transferimports.SearchTransferImportsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImport;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImportQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferImportService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class SearchTransferImportsAction
extends BaseQueryAction {
    private ExternalAccountService externalAccountService;
    private ExternalTransferImportService externalTransferImportService;
    private DataBinder<ExternalTransferImportQuery> dataBinder;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setExternalAccountService(ExternalAccountService externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Inject
    public void setExternalTransferImportService(ExternalTransferImportService externalTransferImportService) {
        this.externalTransferImportService = externalTransferImportService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        List<ExternalTransferImport> imports = this.externalTransferImportService.search((ExternalTransferImportQuery)queryParameters);
        context.getRequest().setAttribute("externalTransferImports", imports);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        SearchTransferImportsForm form = (SearchTransferImportsForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        long externalAccountId = form.getExternalAccountId();
        if (externalAccountId <= 0L) {
            throw new ValidationException();
        }
        ExternalAccount externalAccount = this.externalAccountService.load(externalAccountId, new Relationship[0]);
        request.setAttribute("externalAccount", (Object)externalAccount);
        boolean editable = true;
        request.setAttribute("editable", (Object)true);
        ExternalTransferImportQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setAccount(externalAccount);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<ExternalTransferImportQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<ExternalTransferImportQuery> binder = BeanBinder.instance(ExternalTransferImportQuery.class);
            binder.registerBinder("period", DataBinderHelper.periodBinder(localSettings, "period"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

