/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.certifications;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.certifications.EditCertificationForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.CertificationLog;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.query.PageParameters;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.struts.action.ActionForward;

public class EditCertificationAction
extends BaseFormAction {
    private DataBinder<Certification> dataBinder;
    private CertificationService certificationService;
    private GuaranteeService guaranteeService;

    @Inject
    public void setCertificationService(CertificationService certificationService) {
        this.certificationService = certificationService;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditCertificationForm form = (EditCertificationForm)((Object)context.getForm());
        Certification certification = this.getDataBinder().readFromString(form.getCertification());
        boolean isInsert = certification.isTransient();
        this.initialize(certification, context);
        this.certificationService.save(certification);
        context.sendMessage(isInsert ? "certification.inserted" : "certification.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "certificationId", certification.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditCertificationForm form = (EditCertificationForm)((Object)context.getForm());
        long id = form.getCertificationId();
        boolean isEditable = isInsert = id <= 0L;
        boolean isIssuer = (Boolean)context.getSession().getAttribute("isIssuer");
        if (!isInsert) {
            Certification certification = this.certificationService.load(id, Certification.Relationships.GUARANTEE_TYPE, Certification.Relationships.BUYER);
            this.getDataBinder().writeAsString(form.getCertification(), certification);
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            PageParameters guaranteesPageParameters = new PageParameters(localSettings.getMaxPageResults(), form.getGuaranteesPage());
            List<Guarantee> guarantees = this.guaranteeService.getGuarantees(certification, guaranteesPageParameters, Collections.EMPTY_LIST);
            ActionHelper.ByElementExtractor extractor = new ActionHelper.ByElementExtractor(){

                @Override
                public Element getByElement(Entity entity) {
                    return ((CertificationLog)entity).getBy();
                }
            };
            boolean showGuarantees = !context.isAdmin() || this.permissionService.hasPermission(AdminMemberPermission.GUARANTEES_VIEW_GUARANTEES);
            request.setAttribute("certification", (Object)certification);
            request.setAttribute("showGuarantees", (Object)showGuarantees);
            request.setAttribute("logsBy", ActionHelper.getByElements(context, certification.getLogs(), extractor));
            request.setAttribute("canLock", (Object)this.certificationService.canChangeStatus(certification, Certification.Status.SUSPENDED));
            request.setAttribute("canUnlock", (Object)this.certificationService.canChangeStatus(certification, Certification.Status.ACTIVE));
            request.setAttribute("canCancel", (Object)this.certificationService.canChangeStatus(certification, Certification.Status.CANCELLED));
            request.setAttribute("canDelete", (Object)(guarantees.isEmpty() && this.certificationService.canDelete(certification) ? 1 : 0));
            request.setAttribute("guarantees", guarantees);
            request.setAttribute("usedAmount", (Object)this.certificationService.getUsedAmount(certification, false));
        }
        if (isIssuer) {
            Object group = context.getGroup();
            group = this.groupService.load(((Entity)group).getId(), Group.Relationships.GUARANTEE_TYPES);
            Collection<GuaranteeType> guaranteeTypes = ((Group)group).getEnabledGuaranteeTypes();
            this.filterGuaranteeTypes(guaranteeTypes);
            request.setAttribute("guaranteeTypes", guaranteeTypes);
        }
        if (isEditable) {
            request.setAttribute("buyerGroupIds", (Object)EntityHelper.toIdsAsString(this.guaranteeService.getBuyers()));
        } else {
            request.setAttribute("buyerGroupIds", (Object)"[]");
        }
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("isEditable", (Object)isEditable);
        RequestHelper.storeEnum(request, Amount.Type.class, "amountTypes");
        RequestHelper.storeEnum(request, Certification.Status.class, "status");
        request.setAttribute("fixedFeeType", (Object)GuaranteeType.FeeType.FIXED);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditCertificationForm form = (EditCertificationForm)((Object)context.getForm());
        Certification certification = this.getDataBinder().readFromString(form.getCertification());
        this.initialize(certification, context);
        this.certificationService.validate(certification);
    }

    private void filterGuaranteeTypes(Collection<GuaranteeType> guaranteeTypes) {
        CollectionUtils.filter(guaranteeTypes, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return GuaranteeType.Model.WITH_PAYMENT_OBLIGATION == ((GuaranteeType)object).getModel();
            }
        });
    }

    private DataBinder<Certification> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<Certification> binder = BeanBinder.instance(Certification.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("guaranteeType", PropertyBinder.instance(GuaranteeType.class, "guaranteeType"));
            binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
            binder.registerBinder("buyer", PropertyBinder.instance(Member.class, "buyer"));
            binder.registerBinder("validity", DataBinderHelper.rawPeriodBinder(localSettings, "validity"));
            binder.registerBinder("status", PropertyBinder.instance(Certification.Status.class, "status"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    private void initialize(Certification certification, ActionContext context) {
        certification.setIssuer(EntityHelper.reference(Member.class, ((Member)context.getAccountOwner()).getId()));
    }
}

