/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.certifications;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.certifications.SearchCertificationsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.CertificationQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchCertificationsAction
extends BaseQueryAction {
    private DataBinder<CertificationQuery> dataBinder;
    private CertificationService certificationService;
    private GuaranteeService guaranteeService;

    @Inject
    public void setCertificationService(CertificationService certificationService) {
        this.certificationService = certificationService;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        CertificationQuery query = (CertificationQuery)queryParameters;
        query.fetch(Certification.Relationships.GUARANTEE_TYPE);
        List<CertificationDTO> listCertificationDTOs = this.certificationService.searchWithUsedAmount(query);
        request.setAttribute("listCertificationDTOs", listCertificationDTOs);
        context.getSession().setAttribute("executeCertificationsQuery", (Object)true);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchCertificationsForm form = (SearchCertificationsForm)((Object)context.getForm());
        CertificationQuery query = this.getDataBinder().readFromString(form.getQuery());
        boolean hasViewPermission = this.permissionService.hasPermission(AdminMemberPermission.GUARANTEES_VIEW_CERTIFICATIONS);
        boolean isIssuer = (Boolean)context.getSession().getAttribute("isIssuer");
        boolean isBuyer = (Boolean)context.getSession().getAttribute("isBuyer");
        boolean showBuyer = isIssuer || hasViewPermission;
        boolean showIssuer = context.isAdmin() || isBuyer;
        request.setAttribute("isEditable", (Object)false);
        request.setAttribute("hasViewPermission", (Object)hasViewPermission);
        request.setAttribute("showBuyer", (Object)showBuyer);
        request.setAttribute("showIssuer", (Object)showIssuer);
        request.setAttribute("buyerGroupIds", (Object)(showBuyer ? EntityHelper.toIdsAsString(this.guaranteeService.getBuyers()) : "[]"));
        request.setAttribute("issuerGroupIds", (Object)(showIssuer ? EntityHelper.toIdsAsString(this.guaranteeService.getIssuers()) : "[]"));
        RequestHelper.storeEnum(request, Certification.Status.class, "status");
        if (!hasViewPermission && !isIssuer) {
            if (!context.isMember()) {
                throw new PermissionDeniedException();
            }
            query.setBuyer(EntityHelper.reference(Member.class, ((Member)context.getAccountOwner()).getId()));
        } else if (query.getBuyer() != null) {
            query.setBuyer((Member)this.elementService.load(query.getBuyer().getId(), new Relationship[0]));
        }
        if (isIssuer) {
            query.setIssuer(EntityHelper.reference(Member.class, ((Member)context.getAccountOwner()).getId()));
        } else {
            query.setIssuer(query.getIssuer() == null ? null : (Member)this.elementService.load(query.getIssuer().getId(), new Relationship[0]));
        }
        if (RequestHelper.isFromMenu(request)) {
            context.getSession().setAttribute("executeCertificationsQuery", (Object)false);
        }
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        boolean b = super.willExecuteQuery(context, queryParameters);
        Object executeQuery = context.getSession().getAttribute("executeCertificationsQuery");
        return b || executeQuery != null && (Boolean)executeQuery != false;
    }

    private DataBinder<CertificationQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<CertificationQuery> binder = BeanBinder.instance(CertificationQuery.class);
            binder.registerBinder("startIn", DataBinderHelper.periodBinder(localSettings, "starts"));
            binder.registerBinder("endIn", DataBinderHelper.periodBinder(localSettings, "expires"));
            binder.registerBinder("buyer", PropertyBinder.instance(Member.class, "buyer"));
            binder.registerBinder("issuer", PropertyBinder.instance(Member.class, "issuer"));
            binder.registerBinder("statusList", SimpleCollectionBinder.instance(Certification.Status.class, "statusList"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

