/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.guarantees;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.guarantees.AuthorizeGuaranteeForm;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeFeeVO;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.GuaranteeStatusChangeException;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.MapBean;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import org.apache.struts.action.ActionForward;

public class AuthorizeGuaranteeAction
extends BaseFormAction {
    private GuaranteeService guaranteeService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private DataBinder<Guarantee> dataBinder;
    private DataBinder<Guarantee> readDataBinder;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        AuthorizeGuaranteeForm form = (AuthorizeGuaranteeForm)((Object)context.getForm());
        Guarantee guarantee = this.guaranteeService.load(form.getGuaranteeId(), Guarantee.Relationships.GUARANTEE_TYPE);
        this.updateGuarantee(context, form, guarantee);
        try {
            this.guaranteeService.acceptGuarantee(guarantee, form.isAutomaticLoanAuthorization());
            return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "guaranteeId", guarantee.getId());
        }
        catch (GuaranteeStatusChangeException e) {
            context.sendMessage("guarantee.error.changeStatus", context.message("guarantee.status." + e.getNewstatus(), new Object[0]));
            return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "guaranteeId", guarantee.getId());
        }
        catch (CreditsException e) {
            return context.sendError(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
        catch (UnexpectedEntityException e) {
            return context.sendError("payment.error.invalidTransferType", new Object[0]);
        }
        catch (AuthorizedPaymentInPastException e) {
            return context.sendError("payment.error.authorizedInPast", new Object[0]);
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        AuthorizeGuaranteeForm form = (AuthorizeGuaranteeForm)((Object)context.getForm());
        Long id = form.getGuaranteeId();
        Guarantee guarantee = this.guaranteeService.load(id, Guarantee.Relationships.GUARANTEE_TYPE);
        boolean canAcceptLoan = this.permissionService.hasPermission(AdminSystemPermission.PAYMENTS_AUTHORIZE);
        this.getReadDataBinder().writeAsString(form.getGuarantee(), guarantee);
        if (guarantee.getValidity() == null || guarantee.getValidity().getBegin() == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            CalendarConverter calendarConverter = localSettings.getRawDateConverter();
            ((MapBean)form.getGuarantee("validity")).set("begin", calendarConverter.toString(Calendar.getInstance()));
        }
        TransferType transferType = guarantee.getGuaranteeType().getLoanTransferType();
        List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, false);
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(customFields, guarantee.getCustomValues()));
        request.setAttribute("canAcceptLoan", (Object)canAcceptLoan);
        request.setAttribute("guarantee", (Object)guarantee);
        RequestHelper.storeEnum(request, GuaranteeType.FeeType.class, "feeTypes");
    }

    @Override
    protected void validateForm(ActionContext context) {
        AuthorizeGuaranteeForm form = (AuthorizeGuaranteeForm)((Object)context.getForm());
        Guarantee guarantee = this.getDataBinder().readFromString(form.getGuarantee());
        guarantee.setId(form.getGuaranteeId());
        this.guaranteeService.validate(guarantee, true);
    }

    private DataBinder<Guarantee> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<Guarantee> binder = BeanBinder.instance(Guarantee.class);
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            binder.registerBinder("validity", DataBinderHelper.rawPeriodBinder(localSettings, "validity"));
            binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount"));
            BeanBinder<PaymentCustomFieldValue> customValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
            customValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field"));
            customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
            binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
            BeanBinder<GuaranteeFeeVO> issueFeeBinder = BeanBinder.instance(GuaranteeFeeVO.class, "issueFeeSpec");
            issueFeeBinder.registerBinder("type", PropertyBinder.instance(GuaranteeType.FeeType.class, "type"));
            issueFeeBinder.registerBinder("fee", PropertyBinder.instance(BigDecimal.class, "fee", localSettings.getNumberConverter()));
            binder.registerBinder("issueFeeSpec", issueFeeBinder);
            BeanBinder<GuaranteeFeeVO> creditFeeBinder = BeanBinder.instance(GuaranteeFeeVO.class, "creditFeeSpec");
            creditFeeBinder.registerBinder("type", PropertyBinder.instance(GuaranteeType.FeeType.class, "type"));
            creditFeeBinder.registerBinder("fee", PropertyBinder.instance(BigDecimal.class, "fee", localSettings.getNumberConverter()));
            binder.registerBinder("creditFeeSpec", creditFeeBinder);
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    private DataBinder<Guarantee> getReadDataBinder() {
        if (this.readDataBinder == null) {
            this.readDataBinder = this.getDataBinder();
            this.dataBinder = null;
            BeanBinder beanBinder = (BeanBinder)this.readDataBinder;
            beanBinder.getMappings().remove("customValues");
        }
        return this.readDataBinder;
    }

    private void updateGuarantee(ActionContext context, AuthorizeGuaranteeForm form, Guarantee guarantee) {
        Guarantee updatedGuarantee = this.getDataBinder().readFromString(form.getGuarantee());
        guarantee.setValidity(updatedGuarantee.getValidity());
        guarantee.setCustomValues(updatedGuarantee.getCustomValues());
        if (context.isAdmin() && !guarantee.getGuaranteeType().getCreditFee().isReadonly()) {
            guarantee.setCreditFeeSpec(updatedGuarantee.getCreditFeeSpec());
        }
        if (!guarantee.getGuaranteeType().getIssueFee().isReadonly()) {
            guarantee.setIssueFeeSpec(updatedGuarantee.getIssueFeeSpec());
        }
    }
}

