/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.guarantees;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.guarantees.CalculateGuaranteeFeeAjaxForm;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeFeeCalculationDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeFeeVO;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class CalculateGuaranteeFeeAjaxAction
extends BaseAjaxAction {
    private Map<String, BeanBinder<GuaranteeFeeCalculationDTO>> binderMap = new HashMap<String, BeanBinder<GuaranteeFeeCalculationDTO>>();
    private GuaranteeService guaranteeService;
    private GuaranteeTypeService guaranteeTypeService;

    public DataBinder<GuaranteeFeeCalculationDTO> getDataBinder(String property) {
        BeanBinder<GuaranteeFeeCalculationDTO> binder = this.binderMap.get(property);
        if (binder == null) {
            binder = BeanBinder.instance(GuaranteeFeeCalculationDTO.class);
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            binder.registerBinder("guaranteeTypeId", PropertyBinder.instance(Long.class, "guaranteeTypeId"));
            binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
            binder.registerBinder("validity", DataBinderHelper.rawPeriodBinder(localSettings, "validity"));
            BeanBinder<GuaranteeFeeVO> creditFeeSpecBinder = BeanBinder.instance(GuaranteeFeeVO.class, property);
            creditFeeSpecBinder.registerBinder("type", PropertyBinder.instance(GuaranteeType.FeeType.class, "type"));
            creditFeeSpecBinder.registerBinder("fee", PropertyBinder.instance(BigDecimal.class, "fee", localSettings.getNumberConverter()));
            binder.registerBinder("feeSpec", creditFeeSpecBinder);
            this.binderMap.put(property, binder);
        }
        return binder;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Inject
    public void setGuaranteeTypeService(GuaranteeTypeService guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.XML;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        CalculateGuaranteeFeeAjaxForm form = (CalculateGuaranteeFeeAjaxForm)((Object)context.getForm());
        GuaranteeFeeCalculationDTO creditDTO = this.getDataBinder("creditFeeSpec").readFromString((Object)form);
        GuaranteeFeeCalculationDTO issueDTO = this.getDataBinder("issueFeeSpec").readFromString((Object)form);
        GuaranteeType guaranteeType = EntityHelper.reference(GuaranteeType.class, creditDTO.getGuaranteeTypeId());
        guaranteeType = this.guaranteeTypeService.load(guaranteeType.getId(), GuaranteeType.Relationships.CURRENCY);
        try {
            HashMap<String, String> values = new HashMap<String, String>();
            try {
                String currentCreditFeeValueStr = this.getCurrentFeeValueAsString(guaranteeType, creditDTO);
                String currentIssueFeeValueStr = this.getCurrentFeeValueAsString(guaranteeType, issueDTO);
                values.put("currentCreditFeeValue", currentCreditFeeValueStr);
                values.put("currentIssueFeeValue", currentIssueFeeValueStr);
                this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, values);
            }
            catch (IllegalArgumentException ie) {
                throw new ValidationException("validityBegin", "guarantee.validity", new InvalidError());
            }
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
    }

    private String getCurrentFeeValueAsString(GuaranteeType guaranteeType, GuaranteeFeeCalculationDTO dto) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        if (this.isValid(dto)) {
            BigDecimal currentFeeValue = this.guaranteeService.calculateFee(dto);
            return localSettings.getUnitsConverter(guaranteeType.getCurrency().getPattern()).toString(currentFeeValue);
        }
        return null;
    }

    private boolean isValid(GuaranteeFeeCalculationDTO dto) {
        if (dto.getFeeSpec() == null || dto.getFeeSpec().getType() == null) {
            return false;
        }
        switch (dto.getFeeSpec().getType()) {
            case FIXED: {
                return true;
            }
            case PERCENTAGE: {
                return dto.getAmount() != null;
            }
            case VARIABLE_ACCORDING_TO_TIME: {
                return dto.getAmount() != null && dto.getValidity().getBegin() != null && dto.getValidity().getEnd() != null;
            }
        }
        throw new IllegalArgumentException("Can't check fee spec validity: unknown fee type: " + dto.getFeeSpec().getType());
    }
}

