/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.guarantees;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.guarantees.GuaranteeDetailsForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeLog;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import org.apache.struts.action.ActionForward;

public class GuaranteeDetailsAction
extends BaseFormAction {
    private GuaranteeService guaranteeService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        return null;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        GuaranteeDetailsForm form = (GuaranteeDetailsForm)((Object)context.getForm());
        Long id = form.getGuaranteeId();
        Long certificationId = -1L;
        Guarantee guarantee = this.guaranteeService.load(id, Guarantee.Relationships.PAYMENT_OBLIGATIONS, Guarantee.Relationships.LOGS, RelationshipHelper.nested(Guarantee.Relationships.LOAN, Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER));
        if (guarantee.getCertification() != null) {
            certificationId = guarantee.getCertification().getId();
        }
        ActionHelper.ByElementExtractor extractor = new ActionHelper.ByElementExtractor(){

            @Override
            public Element getByElement(Entity entity) {
                return ((GuaranteeLog)entity).getBy();
            }
        };
        boolean showPaymentObligations = !context.isAdmin() || this.permissionService.hasPermission(AdminMemberPermission.GUARANTEES_VIEW_PAYMENT_OBLIGATIONS);
        TransferType transferType = guarantee.getGuaranteeType().getLoanTransferType();
        List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, true);
        Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, guarantee.getCustomValues());
        request.setAttribute("customFields", entries);
        request.setAttribute("certificationId", (Object)certificationId);
        request.setAttribute("guarantee", (Object)guarantee);
        request.setAttribute("showPaymentObligations", (Object)showPaymentObligations);
        request.setAttribute("logsBy", ActionHelper.getByElements(context, guarantee.getLogs(), extractor));
        request.setAttribute("canAccept", (Object)this.guaranteeService.canChangeStatus(guarantee, Guarantee.Status.ACCEPTED));
        request.setAttribute("canDeny", (Object)this.guaranteeService.canChangeStatus(guarantee, Guarantee.Status.REJECTED));
        request.setAttribute("canCancel", (Object)this.guaranteeService.canChangeStatus(guarantee, Guarantee.Status.CANCELLED));
        request.setAttribute("canDelete", (Object)this.guaranteeService.canRemoveGuarantee(guarantee));
        request.setAttribute("isWithBuyerOnly", (Object)(guarantee.getGuaranteeType().getModel() == GuaranteeType.Model.WITH_BUYER_ONLY ? 1 : 0));
        request.setAttribute("fixedFeeType", (Object)GuaranteeType.FeeType.FIXED);
        request.setAttribute("showCurrentFeeValues", (Object)this.showCurrentFeeValues(guarantee));
        request.setAttribute("showLoan", (Object)this.showLoan(context, guarantee));
    }

    private boolean showCurrentFeeValues(Guarantee guarantee) {
        return guarantee.getLoan() != null && guarantee.getStatus() == Guarantee.Status.ACCEPTED;
    }

    private boolean showLoan(ActionContext context, Guarantee guarantee) {
        if (guarantee.getLoan() == null) {
            return false;
        }
        return this.permissionService.permission(guarantee.getBuyer()).admin(guarantee.getLoan().getStatus().isRelatedToAuthorization() ? AdminMemberPermission.LOANS_VIEW_AUTHORIZED : AdminMemberPermission.LOANS_VIEW).member(MemberPermission.LOANS_VIEW).operator(OperatorPermission.LOANS_VIEW).broker(BrokerPermission.LOANS_VIEW).hasPermission();
    }
}

