/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.guarantees;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.guarantees.RegisterGuaranteeForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeFeeVO;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts.action.ActionForward;

public class RegisterGuaranteeAction
extends BaseFormAction {
    private GuaranteeTypeService guaranteeTypeService;
    private GuaranteeService guaranteeService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private DataBinder<Guarantee> dataBinder;

    public void setDataBinder(DataBinder<Guarantee> dataBinder) {
        this.dataBinder = dataBinder;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Inject
    public void setGuaranteeTypeService(GuaranteeTypeService guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        RegisterGuaranteeForm form = (RegisterGuaranteeForm)((Object)context.getForm());
        Guarantee guarantee = this.getDataBinder().readFromString(form.getGuarantee());
        boolean isInsert = guarantee.isTransient();
        guarantee = this.guaranteeService.registerGuarantee(guarantee);
        if (isInsert) {
            context.sendMessage("guarantee.inserted", new Object[0]);
        } else {
            context.sendMessage("guarantee.modified", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "guaranteeId", guarantee.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        RegisterGuaranteeForm form = (RegisterGuaranteeForm)((Object)context.getForm());
        Long id = form.getGuaranteeTypeId();
        GuaranteeType guaranteeType = this.guaranteeTypeService.load(id, new Relationship[0]);
        Collection<? extends MemberGroup> issuers = this.guaranteeService.getIssuers(guaranteeType);
        if (CollectionUtils.isEmpty(issuers)) {
            throw new ValidationException("guarantee.error.noIssuer", new Object[0]);
        }
        Collection<? extends MemberGroup> sellers = this.guaranteeService.getSellers();
        request.setAttribute("issuerGroupsId", (Object)EntityHelper.toIdsAsString(issuers));
        if (guaranteeType.getModel() != GuaranteeType.Model.WITH_BUYER_ONLY) {
            Collection<? extends MemberGroup> buyers = this.guaranteeService.getBuyers();
            request.setAttribute("buyerGroupsId", (Object)EntityHelper.toIdsAsString(buyers));
        }
        List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(guaranteeType.getLoanTransferType(), false);
        request.setAttribute("customFields", customFields);
        request.setAttribute("sellerGroupsId", (Object)EntityHelper.toIdsAsString(sellers));
        request.setAttribute("isWithBuyerAndSeller", (Object)(guaranteeType.getModel() == GuaranteeType.Model.WITH_BUYER_AND_SELLER ? 1 : 0));
        request.setAttribute("guaranteeType", (Object)guaranteeType);
        RequestHelper.storeEnum(request, GuaranteeType.FeeType.class, "feeTypes");
    }

    @Override
    protected void validateForm(ActionContext context) {
        RegisterGuaranteeForm form = (RegisterGuaranteeForm)((Object)context.getForm());
        Guarantee guarantee = this.getDataBinder().readFromString(form.getGuarantee());
        this.guaranteeService.validate(guarantee, false);
    }

    private DataBinder<Guarantee> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<Guarantee> binder = BeanBinder.instance(Guarantee.class);
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("buyer", PropertyBinder.instance(Member.class, "buyer"));
            binder.registerBinder("seller", PropertyBinder.instance(Member.class, "seller"));
            binder.registerBinder("issuer", PropertyBinder.instance(Member.class, "issuer"));
            binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
            binder.registerBinder("guaranteeType", PropertyBinder.instance(GuaranteeType.class, "guaranteeType"));
            binder.registerBinder("validity", DataBinderHelper.rawPeriodBinder(localSettings, "validity"));
            BeanBinder<PaymentCustomFieldValue> customValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
            customValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field"));
            customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
            binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
            BeanBinder<GuaranteeFeeVO> issueFeeBinder = BeanBinder.instance(GuaranteeFeeVO.class, "issueFeeSpec");
            issueFeeBinder.registerBinder("type", PropertyBinder.instance(GuaranteeType.FeeType.class, "type"));
            issueFeeBinder.registerBinder("fee", PropertyBinder.instance(BigDecimal.class, "fee", localSettings.getNumberConverter()));
            binder.registerBinder("issueFeeSpec", issueFeeBinder);
            BeanBinder<GuaranteeFeeVO> creditFeeBinder = BeanBinder.instance(GuaranteeFeeVO.class, "creditFeeSpec");
            creditFeeBinder.registerBinder("type", PropertyBinder.instance(GuaranteeType.FeeType.class, "type"));
            creditFeeBinder.registerBinder("fee", PropertyBinder.instance(BigDecimal.class, "fee", localSettings.getNumberConverter()));
            binder.registerBinder("creditFeeSpec", creditFeeBinder);
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

