/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.guarantees;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.guarantees.SearchGuaranteesForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeQuery;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchGuaranteesAction
extends BaseQueryAction {
    private DataBinder<GuaranteeQuery> guaranteeDataBinder;
    private GuaranteeService guaranteeService;
    private GuaranteeTypeService guaranteeTypeService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Inject
    public void setGuaranteeTypeService(GuaranteeTypeService guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        GuaranteeQuery query = (GuaranteeQuery)queryParameters;
        query.fetch(RelationshipHelper.nested(Guarantee.Relationships.GUARANTEE_TYPE, GuaranteeType.Relationships.CURRENCY));
        List<Guarantee> guarantees = this.guaranteeService.search(query);
        request.setAttribute("guarantees", guarantees);
        context.getSession().setAttribute("executeGuaranteesQuery", (Object)true);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        SequencedCollection<PaymentCustomField> customFields;
        Collection<GuaranteeType> guaranteeTypes;
        HttpServletRequest request = context.getRequest();
        SearchGuaranteesForm form = (SearchGuaranteesForm)((Object)context.getForm());
        GuaranteeQuery query = this.getGuaranteeDataBinder().readFromString(form.getQuery());
        boolean isIssuer = (Boolean)context.getSession().getAttribute("isIssuer");
        boolean isBuyer = (Boolean)context.getSession().getAttribute("isBuyer");
        boolean isSeller = (Boolean)context.getSession().getAttribute("isSeller");
        boolean hasViewPermission = this.permissionService.hasPermission(AdminMemberPermission.GUARANTEES_VIEW_GUARANTEES);
        boolean hasNoRole = !isIssuer && !isSeller && !isBuyer && !hasViewPermission;
        boolean showIssuer = isSeller || isBuyer || hasViewPermission || hasNoRole;
        boolean showBuyer = isSeller || isIssuer || hasViewPermission;
        boolean showSeller = isBuyer || isIssuer || hasViewPermission;
        boolean showGuaranteeType = isIssuer || hasViewPermission;
        request.setAttribute("hasNoRole", (Object)hasNoRole);
        request.setAttribute("showIssuer", (Object)showIssuer);
        request.setAttribute("showBuyer", (Object)showBuyer);
        request.setAttribute("showSeller", (Object)showSeller);
        request.setAttribute("showGuaranteeType", (Object)showGuaranteeType);
        request.setAttribute("issuerGroupsId", (Object)(showIssuer ? EntityHelper.toIdsAsString(this.guaranteeService.getIssuers()) : "[]"));
        request.setAttribute("buyerGroupsId", (Object)(showBuyer ? EntityHelper.toIdsAsString(this.guaranteeService.getBuyers()) : "[]"));
        request.setAttribute("sellerGroupsId", (Object)(showSeller ? EntityHelper.toIdsAsString(this.guaranteeService.getSellers()) : "[]"));
        request.setAttribute("hasViewPermission", (Object)hasViewPermission);
        query.setIssuer(this.ensureFilter(query.getIssuer()));
        query.setBuyer(this.ensureFilter(query.getBuyer()));
        query.setSeller(this.ensureFilter(query.getSeller()));
        query.setMember(this.ensureFilter(query.getMember()));
        Object group = this.groupService.load(((Entity)context.getGroup()).getId(), Group.Relationships.GUARANTEE_TYPES);
        if (context.isAdmin()) {
            request.setAttribute("guaranteeTypesToRegister", ((Group)group).getEnabledGuaranteeTypes());
            guaranteeTypes = this.guaranteeTypeService.search(new GuaranteeTypeQuery());
        } else {
            guaranteeTypes = ((Group)group).getGuaranteeTypes();
        }
        request.setAttribute("guaranteeTypes", guaranteeTypes);
        Collection<GuaranteeType> guaranteeTypesWithBuyerOnly = this.filterWithBuyerOnly(guaranteeTypes);
        request.setAttribute("guaranteeTypeIdsWithBuyerOnly", (Object)EntityHelper.toIdsAsString(guaranteeTypesWithBuyerOnly));
        RequestHelper.storeEnum(request, Guarantee.Status.class, "guaranteeStatuses");
        if (RequestHelper.isFromMenu(request)) {
            context.getSession().setAttribute("executeGuaranteesQuery", (Object)false);
        }
        if (query.getGuaranteeType() != null) {
            GuaranteeType guaranteeType = this.guaranteeTypeService.load(query.getGuaranteeType().getId(), new Relationship[0]);
            customFields = this.paymentCustomFieldService.list(guaranteeType.getLoanTransferType(), true);
        } else {
            customFields = new LinkedHashSet<PaymentCustomField>();
            for (GuaranteeType guaranteeType : guaranteeTypes) {
                customFields.addAll(this.paymentCustomFieldService.list(guaranteeType.getLoanTransferType(), true));
            }
        }
        Iterator iterator = customFields.iterator();
        while (iterator.hasNext()) {
            PaymentCustomField.Access searchAccess = ((PaymentCustomField)iterator.next()).getSearchAccess();
            if (searchAccess != null && searchAccess != PaymentCustomField.Access.NONE) continue;
            iterator.remove();
        }
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(customFields, query.getCustomValues()));
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        boolean b = super.willExecuteQuery(context, queryParameters);
        Object executeQuery = context.getSession().getAttribute("executeGuaranteesQuery");
        return b || executeQuery != null && (Boolean)executeQuery != false;
    }

    private Member ensureFilter(Member filter) {
        return filter == null ? null : (Member)this.elementService.load(filter.getId(), new Relationship[0]);
    }

    private Collection<GuaranteeType> filterWithBuyerOnly(Collection<GuaranteeType> guaranteeTypes) {
        ArrayList<GuaranteeType> result = new ArrayList<GuaranteeType>();
        for (GuaranteeType gt : guaranteeTypes) {
            if (gt.getModel() != GuaranteeType.Model.WITH_BUYER_ONLY) continue;
            result.add(gt);
        }
        return result;
    }

    private DataBinder<GuaranteeQuery> getGuaranteeDataBinder() {
        if (this.guaranteeDataBinder == null) {
            BeanBinder<PaymentCustomFieldValue> customValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
            customValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field"));
            customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<GuaranteeQuery> binder = BeanBinder.instance(GuaranteeQuery.class);
            binder.registerBinder("statusList", SimpleCollectionBinder.instance(Guarantee.Status.class, "statusList"));
            binder.registerBinder("issuer", PropertyBinder.instance(Member.class, "issuer"));
            binder.registerBinder("buyer", PropertyBinder.instance(Member.class, "buyer"));
            binder.registerBinder("seller", PropertyBinder.instance(Member.class, "seller"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("withBuyerOnly", PropertyBinder.instance(Boolean.class, "withBuyerOnly"));
            binder.registerBinder("startIn", DataBinderHelper.periodBinder(localSettings, "starts"));
            binder.registerBinder("endIn", DataBinderHelper.periodBinder(localSettings, "expires"));
            binder.registerBinder("amountLowerLimit", PropertyBinder.instance(BigDecimal.class, "amountLowerLimit", localSettings.getNumberConverter()));
            binder.registerBinder("amountUpperLimit", PropertyBinder.instance(BigDecimal.class, "amountUpperLimit", localSettings.getNumberConverter()));
            binder.registerBinder("guaranteeType", PropertyBinder.instance(GuaranteeType.class, "guaranteeType"));
            binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.guaranteeDataBinder = binder;
        }
        return this.guaranteeDataBinder;
    }
}

