/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.paymentobligations;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.paymentobligations.AcceptPaymentObligationForm;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationPackDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.ActiveCertificationNotFoundException;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.CertificationAmountExceededException;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.CertificationValidityExceededException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import org.apache.struts.action.ActionForward;

public class AcceptPaymentObligationAction
extends BaseAction {
    private GuaranteeService guaranteeService;

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        AcceptPaymentObligationForm form = (AcceptPaymentObligationForm)((Object)context.getForm());
        Long issuerId = form.getIssuerId();
        Long paymentObligationId = form.getPaymentObligationId();
        try {
            Guarantee guarantee = this.requestGuarantee(paymentObligationId, EntityHelper.reference(Member.class, issuerId));
            context.sendMessage("paymentObligation.requestGuaranteeOk", context.message("guarantee.status." + guarantee.getStatus(), new Object[0]));
        }
        catch (ActiveCertificationNotFoundException e) {
            context.sendMessage("paymentObligation.error.noActiveCertificationFound", e.getBuyer(), e.getIssuer());
        }
        catch (CertificationAmountExceededException e) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            UnitsConverter converter = localSettings.getUnitsConverter(e.getCertification().getGuaranteeType().getCurrency().getPattern());
            context.sendMessage("paymentObligation.error.certificationAmountExceeded", converter.toString(e.getRemainingCertificationAmount()), converter.toString(e.getTotalExceededAmount()));
        }
        catch (CertificationValidityExceededException e) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            CalendarConverter converter = localSettings.getRawDateConverter();
            String validityBegin = converter.toString(e.getCertification().getValidity().getBegin());
            String validityEnd = converter.toString(e.getCertification().getValidity().getEnd());
            context.sendMessage("paymentObligation.error.certificationValidityExceeded", validityBegin, validityEnd);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "paymentObligationId", paymentObligationId);
    }

    private Guarantee requestGuarantee(Long id, Member issuer) {
        PaymentObligationPackDTO pack = new PaymentObligationPackDTO();
        pack.setIssuer(issuer);
        pack.setPaymentObligations(new Long[]{id});
        return this.guaranteeService.requestGuarantee(pack);
    }
}

