/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.paymentobligations;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.paymentobligations.AcceptPaymentObligationPackForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationPackDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationService;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.ActiveCertificationNotFoundException;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.CertificationAmountExceededException;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.CertificationValidityExceededException;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import org.apache.struts.action.ActionForward;

public class AcceptPaymentObligationPackAction
extends BaseFormAction {
    private PaymentObligationService paymentObligationService;
    private CertificationService certificationService;
    private GuaranteeService guaranteeService;

    @Inject
    public void setCertificationService(CertificationService certificationService) {
        this.certificationService = certificationService;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Inject
    public void setPaymentObligationService(PaymentObligationService paymentObligationService) {
        this.paymentObligationService = paymentObligationService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        AcceptPaymentObligationPackForm form = (AcceptPaymentObligationPackForm)((Object)context.getForm());
        Long[] ids = form.getPaymentObligationIds();
        Long issuerId = form.getIssuerId();
        try {
            Guarantee guarantee = this.requestGuarantee(ids, EntityHelper.reference(Member.class, issuerId));
            context.sendMessage("paymentObligation.requestGuaranteeOk", context.message("guarantee.status." + guarantee.getStatus(), new Object[0]));
            return context.getSuccessForward();
        }
        catch (ActiveCertificationNotFoundException e) {
            context.sendMessage("paymentObligation.error.noActiveCertificationFound", e.getBuyer(), e.getIssuer());
            this.acceptPaymentObligation(context);
            return context.getInputForward();
        }
        catch (CertificationAmountExceededException e) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            UnitsConverter converter = localSettings.getUnitsConverter(e.getCertification().getGuaranteeType().getCurrency().getPattern());
            context.sendMessage("paymentObligation.error.certificationAmountExceeded", converter.toString(e.getRemainingCertificationAmount()), converter.toString(e.getTotalExceededAmount()));
            this.acceptPaymentObligation(context);
            return context.getInputForward();
        }
        catch (CertificationValidityExceededException e) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            CalendarConverter converter = localSettings.getRawDateConverter();
            String validityBegin = converter.toString(e.getCertification().getValidity().getBegin());
            String validityEnd = converter.toString(e.getCertification().getValidity().getEnd());
            context.sendMessage("paymentObligation.error.certificationValidityExceeded", validityBegin, validityEnd);
            this.acceptPaymentObligation(context);
            return context.getInputForward();
        }
    }

    @Override
    protected boolean isFormPreparation(ActionContext context) {
        return super.isFormPreparation(context) || Boolean.valueOf(context.getRequest().getParameter("selectIssuer")) != false;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        this.acceptPaymentObligation(context);
    }

    private void acceptPaymentObligation(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        AcceptPaymentObligationPackForm form = (AcceptPaymentObligationPackForm)((Object)context.getForm());
        Long[] ids = form.getPaymentObligationIds();
        if (ids == null || ids.length == 0) {
            return;
        }
        List<PaymentObligation> paymentObligations = this.loadPaymentObligations(ids);
        PaymentObligation po = paymentObligations.get(0);
        List<Member> issuers = this.certificationService.getCertificationIssuers(po);
        request.setAttribute("paymentObligations", paymentObligations);
        request.setAttribute("paymentObligationsTotalAmount", (Object)this.calcTotalAmount(paymentObligations));
        if (issuers == null || issuers.size() == 0) {
            return;
        }
        Member issuer = this.getIssuer(issuers, form);
        Long[] exceeded = this.checkPaymentObligationPeriod(ids, issuer);
        String paymentObligationIds = this.arrayToString(exceeded);
        Certification certification = this.certificationService.getActiveCertification(po.getCurrency(), po.getBuyer(), issuer);
        request.setAttribute("certification", (Object)certification);
        request.setAttribute("issuers", issuers);
        request.setAttribute("paymentObligationIds", (Object)paymentObligationIds);
        request.setAttribute("paymentObligationExceeded", (Object)(exceeded.length > 0 ? 1 : 0));
    }

    private String arrayToString(Long[] ids) {
        if (ids == null || ids.length == 0) {
            return "[]";
        }
        return RequestHelper.arrayToString(ids);
    }

    private BigDecimal calcTotalAmount(List<PaymentObligation> paymentObligations) {
        BigDecimal sum = BigDecimal.ZERO;
        for (PaymentObligation paymentObligation : paymentObligations) {
            sum = sum.add(paymentObligation.getAmount());
        }
        return sum;
    }

    private Long[] checkPaymentObligationPeriod(Long[] ids, Member issuer) {
        PaymentObligationPackDTO dto = new PaymentObligationPackDTO();
        dto.setIssuer(issuer);
        dto.setPaymentObligations(ids);
        Long[] exceeded = this.paymentObligationService.checkPaymentObligationPeriod(dto);
        return exceeded;
    }

    private Member getIssuer(List<Member> issuers, AcceptPaymentObligationPackForm form) {
        if (form.getIssuerId() == null) {
            return issuers.get(0);
        }
        return EntityHelper.reference(Member.class, form.getIssuerId());
    }

    private List<PaymentObligation> loadPaymentObligations(Long[] ids) {
        if (ids == null || ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<PaymentObligation> paymentObligations = new ArrayList<PaymentObligation>();
        for (Long element : ids) {
            paymentObligations.add(this.paymentObligationService.load(element, new Relationship[0]));
        }
        return paymentObligations;
    }

    private Guarantee requestGuarantee(Long[] ids, Member issuer) {
        PaymentObligationPackDTO pack = new PaymentObligationPackDTO();
        pack.setIssuer(issuer);
        pack.setPaymentObligations(ids);
        return this.guaranteeService.requestGuarantee(pack);
    }
}

