/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.paymentobligations;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.paymentobligations.EditPaymentObligationForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.CertificationQuery;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligationLog;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;

public class EditPaymentObligationAction
extends BaseFormAction {
    private DataBinder<PaymentObligation> dataBinder;
    private PaymentObligationService paymentObligationService;
    private CurrencyService currencyService;
    private GuaranteeService guaranteeService;
    private CertificationService certificationService;

    public DataBinder<PaymentObligation> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<PaymentObligation> binder = BeanBinder.instance(PaymentObligation.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("status", PropertyBinder.instance(PaymentObligation.Status.class, "status"));
            binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
            binder.registerBinder("buyer", PropertyBinder.instance(Member.class, "buyer"));
            binder.registerBinder("seller", PropertyBinder.instance(Member.class, "seller"));
            binder.registerBinder("expirationDate", PropertyBinder.instance(Calendar.class, "expirationDate", localSettings.getRawDateConverter()));
            binder.registerBinder("maxPublishDate", PropertyBinder.instance(Calendar.class, "maxPublishDate", localSettings.getRawDateConverter()));
            binder.registerBinder("registrationDate", PropertyBinder.instance(Calendar.class, "registrationDate", localSettings.getRawDateConverter()));
            binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("guarantee", PropertyBinder.instance(Guarantee.class, "guarantee"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setCertificationService(CertificationService certificationService) {
        this.certificationService = certificationService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Inject
    public void setPaymentObligationService(PaymentObligationService paymentObligationService) {
        this.paymentObligationService = paymentObligationService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditPaymentObligationForm form = (EditPaymentObligationForm)((Object)context.getForm());
        PaymentObligation paymentObligation = this.getDataBinder().readFromString(form.getPaymentObligation());
        boolean isInsert = paymentObligation.isTransient();
        this.initialize(paymentObligation, context);
        this.paymentObligationService.save(paymentObligation, true);
        context.sendMessage(isInsert ? "paymentObligation.inserted" : "paymentObligation.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "paymentObligationId", paymentObligation.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditPaymentObligationForm form = (EditPaymentObligationForm)((Object)context.getForm());
        long id = form.getPaymentObligationId();
        boolean isInsert = id <= 0L;
        Long guaranteeId = -1L;
        boolean isBuyer = (Boolean)context.getSession().getAttribute("isBuyer");
        boolean isEditable = isInsert || isBuyer;
        Collection<Currency> currencies = null;
        if (isInsert) {
            if (context.isAdmin() || !isBuyer) {
                throw new PermissionDeniedException();
            }
            currencies = this.resolveAvailableCurrencies(context, null);
        } else {
            PaymentObligation paymentObligation = this.paymentObligationService.load(id, PaymentObligation.Relationships.GUARANTEE, PaymentObligation.Relationships.BUYER, PaymentObligation.Relationships.SELLER);
            currencies = this.resolveAvailableCurrencies(context, paymentObligation);
            if (paymentObligation.getStatus() != PaymentObligation.Status.REGISTERED || !paymentObligation.getBuyer().equals(context.getAccountOwner())) {
                isEditable = false;
            }
            if (paymentObligation.getGuarantee() != null) {
                guaranteeId = paymentObligation.getGuarantee().getId();
            }
            ActionHelper.ByElementExtractor extractor = new ActionHelper.ByElementExtractor(){

                @Override
                public Element getByElement(Entity entity) {
                    return ((PaymentObligationLog)entity).getBy();
                }
            };
            boolean canAccept = this.paymentObligationService.canChangeStatus(paymentObligation, PaymentObligation.Status.ACCEPTED);
            if (canAccept) {
                List<Member> issuers = this.certificationService.getCertificationIssuers(paymentObligation);
                request.setAttribute("issuers", issuers);
            }
            this.getDataBinder().writeAsString(form.getPaymentObligation(), paymentObligation);
            request.setAttribute("paymentObligation", (Object)paymentObligation);
            request.setAttribute("canPublish", (Object)this.paymentObligationService.canChangeStatus(paymentObligation, PaymentObligation.Status.PUBLISHED));
            request.setAttribute("canConceal", (Object)this.paymentObligationService.canChangeStatus(paymentObligation, PaymentObligation.Status.REGISTERED));
            request.setAttribute("canReject", (Object)this.paymentObligationService.canChangeStatus(paymentObligation, PaymentObligation.Status.REJECTED));
            request.setAttribute("canAccept", (Object)canAccept);
            request.setAttribute("canDelete", (Object)this.paymentObligationService.canDelete(paymentObligation));
            request.setAttribute("logsBy", ActionHelper.getByElements(context, paymentObligation.getLogs(), extractor));
        }
        request.setAttribute("guaranteeId", (Object)guaranteeId);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("isEditable", (Object)isEditable);
        request.setAttribute("currencies", currencies);
        if (currencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)currencies.iterator().next());
        }
        if (isEditable) {
            Collection<? extends MemberGroup> sellers = this.guaranteeService.getSellers();
            request.setAttribute("sellerGroupsId", (Object)EntityHelper.toIdsAsString(sellers));
        } else {
            request.setAttribute("sellerGroupsId", (Object)"[]");
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditPaymentObligationForm form = (EditPaymentObligationForm)((Object)context.getForm());
        PaymentObligation paymentObligation = this.getDataBinder().readFromString(form.getPaymentObligation());
        this.initialize(paymentObligation, context);
        this.paymentObligationService.validate(paymentObligation);
    }

    private void initialize(PaymentObligation paymentObligation, ActionContext context) {
        paymentObligation.setBuyer(EntityHelper.reference(Member.class, ((Member)context.getAccountOwner()).getId()));
    }

    private Collection<Currency> resolveAvailableCurrencies(ActionContext context, PaymentObligation paymentObligation) {
        if (context.isAdmin()) {
            return this.currencyService.listAll();
        }
        HashSet<Currency> currencies = new HashSet();
        Member member = (Member)context.getAccountOwner();
        member = (Member)this.elementService.load(member.getId(), Element.Relationships.GROUP);
        if (paymentObligation == null || member.equals(paymentObligation.getBuyer())) {
            CertificationQuery query = new CertificationQuery();
            query.setBuyer((Member)context.getAccountOwner());
            query.setStatusList(Collections.singletonList(Certification.Status.ACTIVE));
            List<Certification> certifications = this.certificationService.search(query);
            for (Certification certification : certifications) {
                currencies.add(certification.getGuaranteeType().getCurrency());
            }
        } else {
            MemberGroup memberGroup = member.getMemberGroup();
            currencies = this.currencyService.listByMemberGroup(memberGroup);
        }
        return currencies;
    }
}

