/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.paymentobligations;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.paymentobligations.SearchPaymentObligationsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.CertificationQuery;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligationQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchPaymentObligationsAction
extends BaseQueryAction {
    private PaymentObligationService paymentObligationService;
    private GuaranteeService guaranteeService;
    private CertificationService certificationService;
    private DataBinder<PaymentObligationQuery> dataBinder;
    private CurrencyService currencyService;

    public CertificationService getCertificationService() {
        return this.certificationService;
    }

    @Inject
    public void setCertificationService(CertificationService certificationService) {
        this.certificationService = certificationService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Inject
    public void setPaymentObligationService(PaymentObligationService paymentObligationService) {
        this.paymentObligationService = paymentObligationService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        PaymentObligationQuery query = (PaymentObligationQuery)queryParameters;
        List<PaymentObligation> paymentObligations = this.paymentObligationService.search(query);
        request.setAttribute("currencies", this.currencyService.listAll());
        request.setAttribute("paymentObligations", paymentObligations);
        context.getSession().setAttribute("executePaymentObligationsQuery", (Object)true);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchPaymentObligationsForm form = (SearchPaymentObligationsForm)((Object)context.getForm());
        PaymentObligationQuery query = this.getDataBinder().readFromString(form.getQuery());
        boolean isBuyer = (Boolean)context.getSession().getAttribute("isBuyer");
        boolean isSeller = (Boolean)context.getSession().getAttribute("isSeller");
        boolean hasViewPermission = this.permissionService.hasPermission(AdminMemberPermission.GUARANTEES_VIEW_PAYMENT_OBLIGATIONS);
        boolean showBuyer = isSeller || hasViewPermission;
        boolean showSeller = isBuyer || hasViewPermission;
        request.setAttribute("hasViewPermission", (Object)hasViewPermission);
        request.setAttribute("showBuyer", (Object)showBuyer);
        request.setAttribute("showSeller", (Object)showSeller);
        request.setAttribute("buyerFiltered", (Object)(query.getBuyer() != null ? 1 : 0));
        request.setAttribute("currencyFiltered", (Object)(query.getCurrency() != null ? 1 : 0));
        request.setAttribute("publishedStatus", (Object)PaymentObligation.Status.PUBLISHED);
        request.setAttribute("registeredStatus", (Object)PaymentObligation.Status.REGISTERED);
        request.setAttribute("buyerGroupIds", (Object)(showBuyer ? EntityHelper.toIdsAsString(this.guaranteeService.getBuyers()) : "[]"));
        request.setAttribute("sellerGroupIds", (Object)(showSeller ? EntityHelper.toIdsAsString(this.guaranteeService.getSellers()) : "[]"));
        request.setAttribute("currencies", this.currencyService.listAll());
        request.setAttribute("status", (Object)this.paymentObligationService.getStatusToFilter());
        boolean showNewPaymentObligationButton = false;
        if (isBuyer) {
            CertificationQuery certificationQuery = new CertificationQuery();
            certificationQuery.setBuyer((Member)context.getAccountOwner());
            certificationQuery.setStatusList(Collections.singletonList(Certification.Status.ACTIVE));
            List<Certification> certifications = this.certificationService.search(certificationQuery);
            showNewPaymentObligationButton = certifications.size() > 0;
        }
        request.setAttribute("showNewPaymentObligationButton", (Object)showNewPaymentObligationButton);
        query.setBuyer(this.ensureFilter(query.getBuyer()));
        query.setSeller(this.ensureFilter(query.getSeller()));
        if (RequestHelper.isFromMenu(request)) {
            context.getSession().setAttribute("executePaymentObligationsQuery", (Object)false);
        }
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        boolean b = super.willExecuteQuery(context, queryParameters);
        Object executeQuery = context.getSession().getAttribute("executePaymentObligationsQuery");
        return b || executeQuery != null && (Boolean)executeQuery != false;
    }

    private Member ensureFilter(Member filter) {
        return filter == null ? null : (Member)this.elementService.load(filter.getId(), new Relationship[0]);
    }

    private DataBinder<PaymentObligationQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<PaymentObligationQuery> binder = BeanBinder.instance(PaymentObligationQuery.class);
            binder.registerBinder("expiration", DataBinderHelper.periodBinder(localSettings, "expiration"));
            binder.registerBinder("buyer", PropertyBinder.instance(Member.class, "buyer"));
            binder.registerBinder("seller", PropertyBinder.instance(Member.class, "seller"));
            binder.registerBinder("statusList", SimpleCollectionBinder.instance(PaymentObligation.Status.class, "statusList"));
            binder.registerBinder("amountLowerLimit", PropertyBinder.instance(BigDecimal.class, "amountLowerLimit", localSettings.getNumberConverter()));
            binder.registerBinder("amountUpperLimit", PropertyBinder.instance(BigDecimal.class, "amountUpperLimit", localSettings.getNumberConverter()));
            binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

