/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.guarantees.types;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.guarantees.types.EditGuaranteeTypeForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeFeeVO;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;

public class EditGuaranteeTypeAction
extends BaseFormAction {
    private GuaranteeTypeService guaranteeTypeService;
    private CurrencyService currencyService;
    private TransferTypeService transferTypeService;
    private DataBinder<GuaranteeType> dataBinderGuaranteeType;

    public DataBinder<GuaranteeType> getDataBinderGuaranteeType() {
        if (this.dataBinderGuaranteeType == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<GuaranteeType> binder = BeanBinder.instance(GuaranteeType.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("model", PropertyBinder.instance(GuaranteeType.Model.class, "model"));
            binder.registerBinder("authorizedBy", PropertyBinder.instance(GuaranteeType.AuthorizedBy.class, "authorizedBy"));
            binder.registerBinder("creditFeePayer", PropertyBinder.instance(GuaranteeType.FeePayer.class, "creditFeePayer"));
            binder.registerBinder("issueFeePayer", PropertyBinder.instance(GuaranteeType.FeePayer.class, "issueFeePayer"));
            binder.registerBinder("enabled", PropertyBinder.instance(Boolean.TYPE, "enabled"));
            binder.registerBinder("paymentObligationPeriod", DataBinderHelper.timePeriodBinder("paymentObligationPeriod"));
            binder.registerBinder("pendingGuaranteeExpiration", DataBinderHelper.timePeriodBinder("pendingGuaranteeExpiration"));
            binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
            binder.registerBinder("creditFeeTransferType", PropertyBinder.instance(TransferType.class, "creditFeeTransferType"));
            binder.registerBinder("issueFeeTransferType", PropertyBinder.instance(TransferType.class, "issueFeeTransferType"));
            binder.registerBinder("forwardTransferType", PropertyBinder.instance(TransferType.class, "forwardTransferType"));
            binder.registerBinder("loanTransferType", PropertyBinder.instance(TransferType.class, "loanTransferType"));
            BeanBinder<GuaranteeTypeFeeVO> issueFeeBinder = BeanBinder.instance(GuaranteeTypeFeeVO.class, "issueFee");
            issueFeeBinder.registerBinder("type", PropertyBinder.instance(GuaranteeType.FeeType.class, "type"));
            issueFeeBinder.registerBinder("fee", PropertyBinder.instance(BigDecimal.class, "fee", localSettings.getNumberConverter()));
            issueFeeBinder.registerBinder("readonly", PropertyBinder.instance(Boolean.TYPE, "readonly"));
            binder.registerBinder("issueFee", issueFeeBinder);
            BeanBinder<GuaranteeTypeFeeVO> creditFeeBinder = BeanBinder.instance(GuaranteeTypeFeeVO.class, "creditFee");
            creditFeeBinder.registerBinder("type", PropertyBinder.instance(GuaranteeType.FeeType.class, "type"));
            creditFeeBinder.registerBinder("fee", PropertyBinder.instance(BigDecimal.class, "fee", localSettings.getNumberConverter()));
            creditFeeBinder.registerBinder("readonly", PropertyBinder.instance(Boolean.TYPE, "readonly"));
            binder.registerBinder("creditFee", creditFeeBinder);
            this.dataBinderGuaranteeType = binder;
        }
        return this.dataBinderGuaranteeType;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setGuaranteeTypeService(GuaranteeTypeService guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditGuaranteeTypeForm form = (EditGuaranteeTypeForm)((Object)context.getForm());
        GuaranteeType guaranteeType = this.getDataBinderGuaranteeType().readFromString(form.getGuaranteeType());
        boolean isInsert = guaranteeType.isTransient();
        guaranteeType = this.guaranteeTypeService.save(guaranteeType);
        if (isInsert) {
            context.sendMessage("guaranteeType.inserted", new Object[0]);
        } else {
            context.sendMessage("guaranteeType.updated", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "guaranteeTypeId", guaranteeType.getId());
    }

    @Override
    protected void prepareForm(final ActionContext context) throws Exception {
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditGuaranteeTypeForm form = (EditGuaranteeTypeForm)((Object)context.getForm());
        Long id = form.getGuaranteeTypeId();
        boolean bl = isInsert = id == null || id <= 0L;
        if (!isInsert) {
            GuaranteeType guaranteeType = this.guaranteeTypeService.load(id, GuaranteeType.Relationships.CURRENCY, GuaranteeType.Relationships.LOAN_TRANSFER_TYPE, GuaranteeType.Relationships.CREDIT_FEE_TRANSFER_TYPE, GuaranteeType.Relationships.ISSUE_FEE_TRANSFER_TYPE, GuaranteeType.Relationships.FORWARD_TRANSFER_TYPE);
            request.setAttribute("guaranteeType", (Object)guaranteeType);
            Currency currency = guaranteeType.getCurrency();
            this.getDataBinderGuaranteeType().writeAsString(form.getGuaranteeType(), guaranteeType);
            this.searchTrasferTypes(request, currency);
        }
        final StringTransformer javaScriptTransformer = new StringTransformer(){

            @Override
            public String transform(Object value) {
                return "'" + value.toString() + "'";
            }
        };
        StringTransformer i18nTransformer = new StringTransformer(){

            @Override
            public String transform(Object value) {
                return javaScriptTransformer.transform(context.message("guaranteeType.authorizedBy." + value, new Object[0]));
            }
        };
        Object[] paymentObligationAuthorizers = new GuaranteeType.AuthorizedBy[]{GuaranteeType.AuthorizedBy.ISSUER, GuaranteeType.AuthorizedBy.BOTH};
        request.setAttribute("allAuthorizersStr", (Object)this.arrayToString(GuaranteeType.AuthorizedBy.values(), javaScriptTransformer));
        request.setAttribute("paymentObligationAuthorizersStr", (Object)this.arrayToString(paymentObligationAuthorizers, javaScriptTransformer));
        request.setAttribute("feePayers", Arrays.asList(GuaranteeType.FeePayer.BUYER, GuaranteeType.FeePayer.SELLER));
        request.setAttribute("paymentObligationAuthorizersI18N", (Object)this.arrayToString(paymentObligationAuthorizers, i18nTransformer));
        request.setAttribute("allAuthorizersI18N", (Object)this.arrayToString(GuaranteeType.AuthorizedBy.values(), i18nTransformer));
        request.setAttribute("currencies", this.currencyService.listAll());
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)this.permissionService.hasPermission(AdminSystemPermission.GUARANTEE_TYPES_MANAGE));
        request.setAttribute("paymentObligationPeriod", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.MONTHS, TimePeriod.Field.YEARS));
        request.setAttribute("pendingGuaranteeExpiration", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.MONTHS, TimePeriod.Field.YEARS));
        RequestHelper.storeEnum(request, GuaranteeType.Model.class, "model");
        RequestHelper.storeEnum(request, GuaranteeType.AuthorizedBy.class, "allAuthorizers");
        RequestHelper.storeEnum(request, GuaranteeType.FeeType.class, "feeTypes");
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditGuaranteeTypeForm form = (EditGuaranteeTypeForm)((Object)context.getForm());
        GuaranteeType guaranteeType = this.getDataBinderGuaranteeType().readFromString(form.getGuaranteeType());
        this.guaranteeTypeService.validate(guaranteeType);
    }

    private String arrayToString(Object[] values, StringTransformer transformer) {
        if (values == null || values.length == 0) {
            return "[]";
        }
        StringBuilder str = new StringBuilder("[");
        for (Object value : values) {
            str.append(transformer.transform(value)).append(",");
        }
        str.delete(str.length() - 1, str.length()).append("]");
        return str.toString();
    }

    private void searchTrasferTypes(HttpServletRequest request, Currency currency) {
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setCurrency(currency);
        ttQuery.setContext(TransactionContext.ANY);
        ttQuery.setFromNature(AccountType.Nature.MEMBER);
        ttQuery.setToNature(AccountType.Nature.SYSTEM);
        request.setAttribute("creditFeeTransferType", this.transferTypeService.search(ttQuery));
        ttQuery.setContext(TransactionContext.ANY);
        ttQuery.setFromNature(AccountType.Nature.MEMBER);
        ttQuery.setToNature(AccountType.Nature.MEMBER);
        List<TransferType> issueFeeQueryResult = this.transferTypeService.search(ttQuery);
        request.setAttribute("issueFeeTransferType", issueFeeQueryResult);
        request.setAttribute("forwardTransferType", issueFeeQueryResult);
        ttQuery.setContext(TransactionContext.AUTOMATIC_LOAN);
        ttQuery.setFromNature(AccountType.Nature.SYSTEM);
        ttQuery.setToNature(AccountType.Nature.MEMBER);
        request.setAttribute("loanTransferType", this.transferTypeService.search(ttQuery));
    }

    private static interface StringTransformer {
        public String transform(Object var1);
    }
}

