/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.paymentfilters;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.paymentfilters.EditPaymentFilterForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditPaymentFilterAction
extends BaseFormAction {
    private PaymentFilterService paymentFilterService;
    private TransferTypeService transferTypeService;
    private AccountTypeService accountTypeService;
    private DataBinder<PaymentFilter> dataBinder;

    public AccountTypeService getAccountTypeService() {
        return this.accountTypeService;
    }

    public DataBinder<PaymentFilter> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<PaymentFilter> binder = BeanBinder.instance(PaymentFilter.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("accountType", PropertyBinder.instance(AccountType.class, "accountType", ReferenceConverter.instance(AccountType.class)));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("showInAccountHistory", PropertyBinder.instance(Boolean.TYPE, "showInAccountHistory"));
            binder.registerBinder("showInReports", PropertyBinder.instance(Boolean.TYPE, "showInReports"));
            binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
            binder.registerBinder("transferTypes", SimpleCollectionBinder.instance(TransferType.class, "transferTypes"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public PaymentFilterService getPaymentFilterService() {
        return this.paymentFilterService;
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setPaymentFilterService(PaymentFilterService paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditPaymentFilterForm form = (EditPaymentFilterForm)((Object)context.getForm());
        PaymentFilter paymentFilter = this.getDataBinder().readFromString(form.getPaymentFilter());
        boolean isInsert = paymentFilter.getId() == null;
        paymentFilter = this.paymentFilterService.save(paymentFilter);
        context.sendMessage(isInsert ? "paymentFilter.inserted" : "paymentFilter.modified", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountTypeId", form.getAccountTypeId());
        params.put("paymentFilterId", paymentFilter.getId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditPaymentFilterForm form = (EditPaymentFilterForm)((Object)context.getForm());
        long accountTypeId = form.getAccountTypeId();
        if (accountTypeId <= 0L) {
            throw new ValidationException();
        }
        AccountType accountType = this.accountTypeService.load(accountTypeId);
        long id = form.getPaymentFilterId();
        boolean bl = isInsert = id <= 0L;
        if (!isInsert) {
            PaymentFilter paymentFilter = this.paymentFilterService.load(id, PaymentFilter.Relationships.GROUPS, PaymentFilter.Relationships.TRANSFER_TYPES);
            request.setAttribute("paymentFilter", (Object)paymentFilter);
            this.getDataBinder().writeAsString(form.getPaymentFilter(), paymentFilter);
        }
        GroupQuery query = new GroupQuery();
        query.setStatus(Group.Status.NORMAL);
        if (accountType.getNature() == AccountType.Nature.SYSTEM) {
            query.setNatures(Group.Nature.ADMIN);
        } else {
            query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
            query.setMemberAccountType((MemberAccountType)accountType);
        }
        List<? extends Group> groups = this.groupService.search(query);
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setContext(TransactionContext.ANY);
        ttQuery.setFromOrToAccountType(accountType);
        List<TransferType> transferTypes = this.transferTypeService.search(ttQuery);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("accountType", (Object)accountType);
        request.setAttribute("groups", groups);
        request.setAttribute("transferTypes", transferTypes);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditPaymentFilterForm form = (EditPaymentFilterForm)((Object)context.getForm());
        PaymentFilter paymentFilter = this.getDataBinder().readFromString(form.getPaymentFilter());
        this.paymentFilterService.validate(paymentFilter);
    }
}

