/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.paymentfilters;

import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.accounts.paymentfilters.SearchPaymentFiltersAjaxForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilterQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;

public class SearchPaymentFiltersAjaxAction
extends BaseAjaxAction {
    private PaymentFilterService paymentFilterService;
    private DataBinder<?> dataBinder;
    private DataBinder<PaymentFilterQuery> queryDataBinder;

    public DataBinder<?> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<PaymentFilter> binder = BeanBinder.instance(PaymentFilter.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id"));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("accountTypeId", PropertyBinder.instance(Long.class, "accountType.id"));
            binder.registerBinder("accountTypeName", PropertyBinder.instance(String.class, "accountType.name"));
            this.dataBinder = BeanCollectionBinder.instance(binder);
        }
        return this.dataBinder;
    }

    public DataBinder<PaymentFilterQuery> getQueryDataBinder() {
        if (this.queryDataBinder == null) {
            BeanBinder<PaymentFilterQuery> binder = BeanBinder.instance(PaymentFilterQuery.class);
            binder.registerBinder("accountTypes", SimpleCollectionBinder.instance(AccountType.class, "accountTypeId"));
            binder.registerBinder("memberGroups", SimpleCollectionBinder.instance(MemberGroup.class, "memberGroups"));
            this.queryDataBinder = binder;
        }
        return this.queryDataBinder;
    }

    @Inject
    public void setPaymentFilterService(PaymentFilterService paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        SearchPaymentFiltersAjaxForm form = (SearchPaymentFiltersAjaxForm)((Object)context.getForm());
        PaymentFilterQuery pfQuery = this.getQueryDataBinder().readFromString((Object)form);
        HashSet<Relationship> fetch = new HashSet<Relationship>();
        fetch.add(PaymentFilter.Relationships.ACCOUNT_TYPE);
        pfQuery.setFetch(fetch);
        pfQuery.setContext(PaymentFilterQuery.Context.REPORT);
        List<PaymentFilter> paymentFilters = this.paymentFilterService.search(pfQuery);
        String json = this.getDataBinder().readAsString(paymentFilters);
        this.responseHelper.writeJSON(context.getResponse(), json);
    }
}

