/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.pos;

import java.util.HashMap;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.pos.EditPosForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.accounts.pos.PosService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class AssignPosAction
extends BaseFormAction {
    private PosService posService;

    @Inject
    public void setPosService(PosService posService) {
        this.posService = posService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditPosForm form = (EditPosForm)((Object)context.getForm());
        String posId = form.getPosId();
        long memberId = form.getMemberId();
        if (memberId <= 0L) {
            throw new PermissionDeniedException();
        }
        Member member = (Member)this.elementService.load(memberId, new Relationship[0]);
        try {
            Pos pos = this.posService.loadByPosId(posId, new Relationship[0]);
            pos = this.posService.assignPos(member, pos.getId());
            context.sendMessage("pos.assigned", member.getUsername());
        }
        catch (EntityNotFoundException e) {
            CurrentTransactionData.clearError();
            Pos pos = new Pos();
            pos.setPosId(posId);
            pos = this.posService.save(pos);
            pos = this.posService.assignPos(member, pos.getId());
            context.sendMessage("pos.createdAndAssigned", member.getUsername());
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "memberId", memberId);
    }

    @Override
    protected ActionForward handleValidation(ActionContext context) {
        HashMap<String, String> fields = new HashMap<String, String>();
        try {
            this.validateForm(context);
            EditPosForm form = (EditPosForm)((Object)context.getForm());
            Pos pos = this.posService.loadByPosId(form.getPosId(), new Relationship[0]);
            if (pos.getStatus() == Pos.Status.UNASSIGNED) {
                fields.put("validationMessage", "POS_AVAILABLE");
            } else {
                fields.put("validationMessage", "POS_UNAVAILABLE");
                fields.put("errorMessage", context.message("pos.error.unvailable", new Object[0]));
            }
            this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, fields);
        }
        catch (EntityNotFoundException e) {
            if (this.permissionService.hasPermission(AdminMemberPermission.POS_MANAGE) || this.permissionService.hasPermission(BrokerPermission.POS_MANAGE)) {
                fields.put("validationMessage", "POS_NOT_FOUND");
                fields.put("confirmationMessage", context.message("pos.createAndAssign", new Object[0]));
            } else {
                fields.put("validationMessage", "POS_UNAVAILABLE");
                fields.put("errorMessage", context.message("pos.error.noAssignPermission", new Object[0]));
            }
            this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, fields);
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
        return null;
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditPosForm form = (EditPosForm)((Object)context.getForm());
        if (form.getMemberId() <= 0L) {
            throw new ValidationException();
        }
    }
}

