/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.pos;

import java.util.Calendar;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.pos.EditPosForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.accounts.pos.MemberPosService;
import nl.strohalm.cyclos.services.accounts.pos.PosService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import org.apache.struts.action.ActionForward;

public class EditPosAction
extends BaseFormAction {
    private DataBinder<Pos> writeDataBinder;
    private PosService posService;
    private MemberPosService memberPosService;

    public DataBinder<Pos> getWriteDataBinder() {
        if (this.writeDataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<MemberPos> memberPos = BeanBinder.instance(MemberPos.class, "memberPos");
            memberPos.registerBinder("id", PropertyBinder.instance(Long.class, "id"));
            memberPos.registerBinder("posName", PropertyBinder.instance(String.class, "posName"));
            memberPos.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            memberPos.registerBinder("status", PropertyBinder.instance(MemberPos.Status.class, "status"));
            memberPos.registerBinder("allowMakePayment", PropertyBinder.instance(Boolean.TYPE, "allowMakePayment"));
            memberPos.registerBinder("resultPageSize", PropertyBinder.instance(Integer.class, "resultPageSize"));
            memberPos.registerBinder("numberOfCopies", PropertyBinder.instance(Integer.class, "numberOfCopies"));
            memberPos.registerBinder("maxSchedulingPayments", PropertyBinder.instance(Integer.class, "maxSchedulingPayments"));
            memberPos.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getDateConverter()));
            BeanBinder<Pos> binder = BeanBinder.instance(Pos.class);
            binder.registerBinder("posId", PropertyBinder.instance(String.class, "posId"));
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("status", PropertyBinder.instance(Pos.Status.class, "status"));
            binder.registerBinder("memberPos", memberPos);
            this.writeDataBinder = binder;
        }
        return this.writeDataBinder;
    }

    @Inject
    public void setMemberPosService(MemberPosService memberPosService) {
        this.memberPosService = memberPosService;
    }

    @Inject
    public void setPosService(PosService posService) {
        this.posService = posService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditPosForm form = (EditPosForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        Pos pos = this.getWriteDataBinder().readFromString(form.getPos());
        try {
            MemberPos persistedMemberPos;
            String operation = form.getOperation();
            if (operation.equals("block")) {
                persistedMemberPos = this.memberPosService.load(pos.getMemberPos().getId(), new Relationship[0]);
                this.memberPosService.blockMemberPos(persistedMemberPos);
                context.sendMessage("pos.blocked", new Object[0]);
            } else if (operation.equals("unblock")) {
                persistedMemberPos = this.memberPosService.load(pos.getMemberPos().getId(), new Relationship[0]);
                this.memberPosService.unblockMemberPos(persistedMemberPos);
                context.sendMessage("pos.unblocked", new Object[0]);
            } else if (operation.equals("unblockPin")) {
                persistedMemberPos = this.memberPosService.load(pos.getMemberPos().getId(), new Relationship[0]);
                this.memberPosService.unblockPosPin(persistedMemberPos);
                context.sendMessage("pos.pinUnblocked", new Object[0]);
            } else if (operation.equals("assign")) {
                Member member = (Member)this.elementService.load(Long.parseLong(form.getAssignTo()), new Relationship[0]);
                this.posService.assignPos(member, pos.getId());
                context.sendMessage("pos.assigned", member.getUsername());
            } else if (operation.equals("changePin")) {
                persistedMemberPos = this.memberPosService.load(pos.getMemberPos().getId(), new Relationship[0]);
                this.memberPosService.changePin(persistedMemberPos, form.getPin());
                context.sendMessage("pos.pinChanged", new Object[0]);
            } else if (operation.equals("discard")) {
                this.posService.discardPos(pos.getId());
                context.sendMessage("pos.discarded", new Object[0]);
            } else if (operation.equals("unassign")) {
                this.posService.unassignPos(pos.getId());
                context.sendMessage("pos.unassigned", new Object[0]);
            } else if (operation.equals("updatePos")) {
                Pos persistedPos = this.posService.load(pos.getId(), new Relationship[0]);
                boolean persistMemberPos = false;
                MemberPos memberPos = null;
                if (pos.getMemberPos() != null && pos.getMemberPos().getId() != null) {
                    MemberPos persistedMemberPos2 = this.memberPosService.load(pos.getMemberPos().getId(), new Relationship[0]);
                    memberPos = pos.getMemberPos();
                    memberPos.setDate(persistedMemberPos2.getDate());
                    memberPos.setMember(persistedMemberPos2.getMember());
                    memberPos.setStatus(persistedMemberPos2.getStatus());
                    memberPos.setPosPin(persistedMemberPos2.getPosPin());
                    persistMemberPos = true;
                } else {
                    pos.setMemberPos(null);
                }
                pos.setPosId(persistedPos.getPosId());
                pos.setStatus(persistedPos.getStatus());
                this.posService.save(pos);
                if (persistMemberPos) {
                    memberPos.setPos(pos);
                    this.memberPosService.save(memberPos);
                }
                context.sendMessage("pos.updated", new Object[0]);
            } else if (operation.equals("newPos")) {
                pos.setMemberPos(null);
                this.posService.save(pos);
                context.sendMessage("pos.created", new Object[0]);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", pos.getId());
            if (form.getMemberId() > 0L) {
                params.put("memberId", form.getMemberId());
            }
            return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
        }
        catch (BlockedCredentialsException e) {
            request.getSession().invalidate();
            return context.sendError("card.updateCard.error.userBlocked", new Object[0]);
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        Pos pos;
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditPosForm form = (EditPosForm)((Object)context.getForm());
        long id = form.getId();
        boolean hasMemberPos = false;
        PosEditionPermissions permissions = this.checkPermissionsInformation(context);
        boolean bl = isInsert = id <= 0L;
        if (isInsert) {
            pos = new Pos();
            pos.setStatus(Pos.Status.UNASSIGNED);
        } else {
            pos = this.posService.load(id, Pos.Relationships.MEMBER_POS);
            boolean bl2 = hasMemberPos = pos.getMemberPos() != null;
            if (hasMemberPos) {
                request.setAttribute("memberLogin", (Object)pos.getMemberPos().getMember().getUsername());
                request.setAttribute("userName", (Object)pos.getMemberPos().getMember().getName());
            }
        }
        this.getWriteDataBinder().writeAsString(form.getPos(), pos);
        request.setAttribute("pos", (Object)pos);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("hasMemberPos", (Object)hasMemberPos);
        request.setAttribute("isRegularUser", (Object)(!context.isAdmin() && !context.isBroker() ? 1 : 0));
        request.setAttribute("canAssign", (Object)permissions.isCanAssign());
        request.setAttribute("canBlock", (Object)permissions.isCanBlock());
        request.setAttribute("canChangeParameters", (Object)permissions.isCanChangeParameters());
        request.setAttribute("canChangePin", (Object)permissions.isCanChangePin());
        request.setAttribute("canDiscard", (Object)permissions.isCanDiscard());
        request.setAttribute("canUnassign", (Object)permissions.isCanUnassign());
        request.setAttribute("canUnblock", (Object)permissions.isCanUnblock());
        request.setAttribute("canUnblockPin", (Object)permissions.isCanUnblockPin());
        request.setAttribute("editable", (Object)permissions.isEditable());
        request.setAttribute("isDiscarded", (Object)permissions.isDiscarded());
        request.setAttribute("memberId", (Object)form.getMemberId());
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditPosForm form = (EditPosForm)((Object)context.getForm());
        Pos pos = this.getWriteDataBinder().readFromString(form.getPos());
        this.posService.validate(pos);
    }

    private PosEditionPermissions checkPermissionsInformation(ActionContext context) {
        PosEditionPermissions permissions = new PosEditionPermissions();
        EditPosForm form = (EditPosForm)((Object)context.getForm());
        boolean hasMemberPos = false;
        long id = form.getId();
        boolean isInsert = id <= 0L;
        permissions.setEditable(this.permissionService.hasPermission(AdminMemberPermission.POS_MANAGE) || this.permissionService.hasPermission(BrokerPermission.POS_MANAGE));
        if (isInsert) {
            if (!context.isBroker() && !context.isAdmin()) {
                throw new PermissionDeniedException();
            }
        } else {
            Pos pos = this.posService.load(id, Pos.Relationships.MEMBER_POS);
            hasMemberPos = pos.getMemberPos() != null;
            Member member = null;
            if (hasMemberPos) {
                AdminGroup group;
                member = pos.getMemberPos().getMember();
                if (member.equals(context.getElement())) {
                    permissions.setEditable(true);
                }
                if (!context.isBroker() && !context.isAdmin() && !member.equals(context.getElement()) || context.isBroker() && !context.isBrokerOf(member) && !member.equals(context.getElement())) {
                    throw new PermissionDeniedException();
                }
                if (context.isAdmin() && !(group = (AdminGroup)this.groupService.load(((Entity)context.getGroup()).getId(), AdminGroup.Relationships.MANAGES_GROUPS)).getManagesGroups().contains(pos.getMemberPos().getMember().getGroup())) {
                    throw new PermissionDeniedException();
                }
            } else if (!context.isBroker() && !context.isAdmin()) {
                throw new PermissionDeniedException();
            }
            if (context.isAdmin() || context.isBroker() && !hasMemberPos || context.isBroker() && hasMemberPos && !member.equals(context.getElement())) {
                boolean isAdmin = context.isAdmin();
                switch (pos.getStatus()) {
                    case UNASSIGNED: {
                        permissions.setCanAssign(this.permissionService.hasPermission((Permission)((Object)(isAdmin ? AdminMemberPermission.POS_ASSIGN : BrokerPermission.POS_ASSIGN))));
                        break;
                    }
                    case ASSIGNED: {
                        permissions.setCanUnassign(this.permissionService.hasPermission((Permission)((Object)(isAdmin ? AdminMemberPermission.POS_ASSIGN : BrokerPermission.POS_ASSIGN))));
                        permissions.setCanChangePin(this.permissionService.hasPermission((Permission)((Object)(isAdmin ? AdminMemberPermission.POS_CHANGE_PIN : BrokerPermission.POS_CHANGE_PIN))));
                        if (!hasMemberPos) break;
                        MemberPos.Status status = pos.getMemberPos().getStatus();
                        if (status == MemberPos.Status.ACTIVE) {
                            permissions.setCanBlock(this.permissionService.hasPermission((Permission)((Object)(isAdmin ? AdminMemberPermission.POS_BLOCK : BrokerPermission.POS_BLOCK))));
                        }
                        if (status == MemberPos.Status.BLOCKED) {
                            permissions.setCanUnblock(this.permissionService.hasPermission((Permission)((Object)(isAdmin ? AdminMemberPermission.POS_BLOCK : BrokerPermission.POS_BLOCK))));
                        }
                        if (status != MemberPos.Status.PIN_BLOCKED) break;
                        permissions.setCanUnblockPin(this.permissionService.hasPermission((Permission)((Object)(isAdmin ? AdminMemberPermission.POS_UNBLOCK_PIN : BrokerPermission.POS_UNBLOCK_PIN))));
                        break;
                    }
                    case DISCARDED: {
                        permissions.setDiscarded(true);
                    }
                }
                if (pos.getStatus() != Pos.Status.DISCARDED) {
                    permissions.setCanDiscard(this.permissionService.hasPermission((Permission)((Object)(isAdmin ? AdminMemberPermission.POS_DISCARD : BrokerPermission.POS_DISCARD))));
                }
                permissions.setCanChangeParameters(this.permissionService.hasPermission((Permission)((Object)(isAdmin ? AdminMemberPermission.POS_CHANGE_PARAMETERS : BrokerPermission.POS_CHANGE_PARAMETERS))));
            } else if (context.isMember() && hasMemberPos && ((Entity)context.getElement()).equals(member)) {
                permissions.setCanChangeParameters(true);
                MemberPos.Status status = pos.getMemberPos().getStatus();
                if (status == MemberPos.Status.ACTIVE) {
                    permissions.setCanBlock(true);
                } else if (status == MemberPos.Status.BLOCKED) {
                    permissions.setCanUnblock(true);
                } else if (status == MemberPos.Status.PIN_BLOCKED) {
                    permissions.setCanUnblockPin(true);
                }
                if (pos.getStatus().equals(Pos.Status.ASSIGNED)) {
                    permissions.setCanChangePin(true);
                }
            }
        }
        return permissions;
    }

    private class PosEditionPermissions {
        private boolean canAssign;
        private boolean canBlock;
        private boolean canChangeParameters;
        private boolean canChangePin;
        private boolean canDiscard;
        private boolean canUnassign;
        private boolean canUnblock;
        private boolean canUnblockPin;
        private boolean editable;
        private boolean isDiscarded;

        private PosEditionPermissions() {
        }

        public boolean isCanAssign() {
            return this.canAssign;
        }

        public boolean isCanBlock() {
            return this.canBlock;
        }

        public boolean isCanChangeParameters() {
            return this.canChangeParameters;
        }

        public boolean isCanChangePin() {
            return this.canChangePin;
        }

        public boolean isCanDiscard() {
            return this.canDiscard;
        }

        public boolean isCanUnassign() {
            return this.canUnassign;
        }

        public boolean isCanUnblock() {
            return this.canUnblock;
        }

        public boolean isCanUnblockPin() {
            return this.canUnblockPin;
        }

        public boolean isDiscarded() {
            return this.isDiscarded;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setCanAssign(boolean canAssign) {
            this.canAssign = canAssign;
        }

        public void setCanBlock(boolean canBlock) {
            this.canBlock = canBlock;
        }

        public void setCanChangeParameters(boolean canChangeParameters) {
            this.canChangeParameters = canChangeParameters;
        }

        public void setCanChangePin(boolean canChangePin) {
            this.canChangePin = canChangePin;
        }

        public void setCanDiscard(boolean canDiscard) {
            this.canDiscard = canDiscard;
        }

        public void setCanUnassign(boolean canUnassign) {
            this.canUnassign = canUnassign;
        }

        public void setCanUnblock(boolean canUnblock) {
            this.canUnblock = canUnblock;
        }

        public void setCanUnblockPin(boolean canUnblockPin) {
            this.canUnblockPin = canUnblockPin;
        }

        public void setDiscarded(boolean isDiscarded) {
            this.isDiscarded = isDiscarded;
        }

        public void setEditable(boolean editable) {
            this.editable = editable;
        }
    }
}

