/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.pos;

import java.util.Calendar;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.pos.EditPosForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;

public class MemberPosAction
extends BaseFormAction {
    private DataBinder<MemberPos> dataBinder;

    public DataBinder<MemberPos> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MemberPos> binder = BeanBinder.instance(MemberPos.class);
            binder.registerBinder("posId", PropertyBinder.instance(String.class, "posId"));
            binder.registerBinder("posName", PropertyBinder.instance(String.class, "posName"));
            binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        EditPosForm form = (EditPosForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        long memberId = form.getMemberId();
        if (memberId <= 0L) {
            throw new PermissionDeniedException();
        }
        Member member = (Member)this.elementService.load(memberId, new Relationship[0]);
        Collection<MemberPos> memberPos = member.getPosDevices();
        request.setAttribute("memberPos", memberPos);
        request.setAttribute("memberId", (Object)memberId);
        request.setAttribute("isOwnUser", (Object)member.equals(context.getElement()));
        Permission permission = (Permission)((Object)(context.isBroker() ? BrokerPermission.POS_ASSIGN : AdminMemberPermission.POS_ASSIGN));
        request.setAttribute("canAssign", (Object)this.permissionService.hasPermission(permission));
    }
}

