/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.pos;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.pos.SearchPosForm;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.accounts.pos.PosQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.pos.PosService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchPosAction
extends BaseQueryAction {
    private DataBinder<PosQuery> dataBinder;
    private PosService posService;

    public DataBinder<PosQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<PosQuery> binder = BeanBinder.instance(PosQuery.class);
            binder.registerBinder("posId", PropertyBinder.instance(String.class, "posId"));
            binder.registerBinder("statuses", SimpleCollectionBinder.instance(PosQuery.QueryStatus.class, "statuses"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setPosService(PosService posService) {
        this.posService = posService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        PosQuery query = (PosQuery)queryParameters;
        List<Pos> pos = this.posService.search(query);
        context.getRequest().setAttribute("pos", pos);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        SearchPosForm form = (SearchPosForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        PosQuery query = this.getDataBinder().readFromString(form.getQuery());
        if (query.getMember() != null) {
            Member member = (Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER);
            query.setMember(member);
        }
        if (context.isBroker()) {
            query.setBroker((Member)context.getElement());
        }
        RequestHelper.storeEnum(request, PosQuery.QueryStatus.class, "statuses");
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

