/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.transactionfees;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.transactionfees.EditTransactionFeeForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.SimpleTransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditTransactionFeeAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private TransactionFeeService transactionFeeService;
    private TransferTypeService transferTypeService;
    private Map<TransactionFee.Nature, DataBinder<? extends TransactionFee>> dataBinders;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<? extends TransactionFee> getDataBinder(TransactionFee.Nature nature) {
        try {
            this.lock.readLock().lock();
            if (this.dataBinders == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                EnumMap<TransactionFee.Nature, DataBinder<? extends TransactionFee>> temp = new EnumMap<TransactionFee.Nature, DataBinder<? extends TransactionFee>>(TransactionFee.Nature.class);
                BeanBinder<SimpleTransactionFee> simpleBinder = BeanBinder.instance(SimpleTransactionFee.class);
                this.initBasic(simpleBinder, localSettings);
                simpleBinder.registerBinder("receiver", PropertyBinder.instance(TransactionFee.Subject.class, "receiver"));
                simpleBinder.registerBinder("toFixedMember", PropertyBinder.instance(Member.class, "toFixedMember"));
                simpleBinder.registerBinder("h", PropertyBinder.instance(BigDecimal.class, "h", localSettings.getHighPrecisionConverter()));
                simpleBinder.registerBinder("aFIsZero", PropertyBinder.instance(BigDecimal.class, "aFIsZero", localSettings.getHighPrecisionConverter()));
                simpleBinder.registerBinder("f1", PropertyBinder.instance(BigDecimal.class, "f1", localSettings.getHighPrecisionConverter()));
                simpleBinder.registerBinder("fInfinite", PropertyBinder.instance(BigDecimal.class, "fInfinite", localSettings.getHighPrecisionConverter()));
                simpleBinder.registerBinder("fMinimal", PropertyBinder.instance(BigDecimal.class, "fMinimal", localSettings.getHighPrecisionConverter()));
                simpleBinder.registerBinder("gFIsZero", PropertyBinder.instance(BigDecimal.class, "gFIsZero", localSettings.getHighPrecisionConverter()));
                temp.put(TransactionFee.Nature.SIMPLE, simpleBinder);
                BeanBinder<BrokerCommission> brokerBinder = BeanBinder.instance(BrokerCommission.class);
                this.initBasic(brokerBinder, localSettings);
                brokerBinder.registerBinder("whichBroker", PropertyBinder.instance(BrokerCommission.WhichBroker.class, "whichBroker"));
                brokerBinder.registerBinder("maxFixedValue", PropertyBinder.instance(BigDecimal.class, "maxFixedValue", localSettings.getNumberConverter()));
                brokerBinder.registerBinder("maxPercentageValue", PropertyBinder.instance(BigDecimal.class, "maxPercentageValue", localSettings.getNumberConverter()));
                brokerBinder.registerBinder("when", PropertyBinder.instance(BrokerCommission.When.class, "when"));
                brokerBinder.registerBinder("count", PropertyBinder.instance(Integer.class, "count"));
                brokerBinder.registerBinder("allBrokerGroups", PropertyBinder.instance(Boolean.TYPE, "allBrokerGroups"));
                brokerBinder.registerBinder("brokerGroups", SimpleCollectionBinder.instance(MemberGroup.class, "brokerGroups"));
                temp.put(TransactionFee.Nature.BROKER, brokerBinder);
                this.dataBinders = temp;
            }
            DataBinder<? extends TransactionFee> dataBinder = this.dataBinders.get(nature);
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinders = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        GroupQuery groupQuery;
        TransactionFee.Nature nature;
        HttpServletRequest request = context.getRequest();
        EditTransactionFeeForm form = (EditTransactionFeeForm)((Object)context.getForm());
        long accountTypeId = form.getAccountTypeId();
        long transferTypeId = form.getTransferTypeId();
        if (accountTypeId <= 0L || transferTypeId <= 0L) {
            throw new ValidationException();
        }
        boolean editableGeneratedTT = true;
        TransferType transferType = this.transferTypeService.load(transferTypeId, RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY), TransferType.Relationships.TO);
        long id = form.getTransactionFeeId();
        boolean isInsert = id <= 0L;
        SimpleTransactionFee.ARateRelation arateRelation = SimpleTransactionFee.ARateRelation.LINEAR;
        if (isInsert) {
            nature = CoercionHelper.coerce(TransactionFee.Nature.class, form.getNature());
            if (nature == null) {
                throw new ValidationException();
            }
            form.setTransactionFee("fromAllGroups", "true");
            form.setTransactionFee("toAllGroups", "true");
            form.setTransactionFee("allBrokerGroups", "true");
            EnumSet<BrokerCommission.WhichBroker> whichBrokers = nature == TransactionFee.Nature.BROKER ? EnumSet.allOf(BrokerCommission.WhichBroker.class) : null;
            Collection<TransactionFee.Subject> possibleSubjects = this.transactionFeeService.getPossibleSubjects(transferType, nature);
            request.setAttribute("possibleSubjects", possibleSubjects);
            request.setAttribute("whichBrokers", whichBrokers);
            if (possibleSubjects != null & possibleSubjects.size() == 1) {
                request.setAttribute("singleSubject", (Object)possibleSubjects.iterator().next());
            }
        } else {
            TransactionFee transactionFee = this.transactionFeeService.load(id, TransactionFee.Relationships.ORIGINAL_TRANSFER_TYPE, RelationshipHelper.nested(TransactionFee.Relationships.GENERATED_TRANSFER_TYPE, TransferType.Relationships.FROM));
            TransferType generatedType = transactionFee.getGeneratedTransferType();
            nature = transactionFee.getNature();
            List<TransferType> possibleGeneratedTypes = null;
            if (nature == TransactionFee.Nature.BROKER) {
                editableGeneratedTT = generatedType.isFromSystem();
                possibleGeneratedTypes = Collections.singletonList(generatedType);
            } else {
                SimpleTransactionFee simpleFee = (SimpleTransactionFee)transactionFee;
                possibleGeneratedTypes = this.transactionFeeService.searchGeneratedTransferTypes(transactionFee, form.isAllowAnyAccount(), generatedType.isFromSystem());
                if (!possibleGeneratedTypes.contains(generatedType) && !form.isAllowAnyAccount()) {
                    form.setAllowAnyAccount(true);
                    possibleGeneratedTypes = this.transactionFeeService.searchGeneratedTransferTypes(transactionFee, form.isAllowAnyAccount(), false);
                }
                arateRelation = simpleFee.getfInfinite() == null ? SimpleTransactionFee.ARateRelation.LINEAR : SimpleTransactionFee.ARateRelation.ASYMPTOTICAL;
            }
            request.setAttribute("generatedTransferTypes", possibleGeneratedTypes);
            request.setAttribute("transactionFee", (Object)transactionFee);
            this.getDataBinder(nature).writeAsString(form.getTransactionFee(), transactionFee);
        }
        request.setAttribute("transferType", (Object)transferType);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editableGeneratedTT", (Object)editableGeneratedTT);
        EnumSet<TransactionFee.Subject> subjects = EnumSet.allOf(TransactionFee.Subject.class);
        if (nature == TransactionFee.Nature.BROKER) {
            subjects.remove(TransactionFee.Subject.SOURCE_BROKER);
            subjects.remove(TransactionFee.Subject.DESTINATION_BROKER);
        }
        request.setAttribute("subjects", subjects);
        RequestHelper.storeEnum(request, TransactionFee.Nature.class, "natures");
        RequestHelper.storeEnum(request, BrokerCommission.When.class, "whens");
        RequestHelper.storeEnum(request, Amount.Type.class, "amountTypes");
        Collection<TransactionFee.ChargeType> chargeTypes = this.transactionFeeService.getPossibleChargeType(transferType, nature);
        request.setAttribute("allowARate", (Object)(chargeTypes.contains(TransactionFee.ChargeType.A_RATE) && chargeTypes.contains(TransactionFee.ChargeType.MIXED_A_D_RATES) ? 1 : 0));
        request.setAttribute("allowDRate", (Object)chargeTypes.contains(TransactionFee.ChargeType.D_RATE));
        if (nature == TransactionFee.Nature.SIMPLE && transferType.isFromMember() && transferType.isToSystem() && !transferType.getTo().isLimited()) {
            RequestHelper.storeEnum(request, SimpleTransactionFee.ARateRelation.class, "aRateRelations");
            form.setTransactionFee("aRateRelation", arateRelation.name());
        }
        request.setAttribute("chargeTypes", chargeTypes);
        if (transferType.isFromMember()) {
            groupQuery = new GroupQuery();
            groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
            groupQuery.setStatus(Group.Status.NORMAL);
            groupQuery.setMemberAccountType((MemberAccountType)transferType.getFrom());
            request.setAttribute("possibleFromGroups", this.groupService.search(groupQuery));
        }
        if (transferType.isToMember()) {
            groupQuery = new GroupQuery();
            groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
            groupQuery.setStatus(Group.Status.NORMAL);
            groupQuery.setMemberAccountType((MemberAccountType)transferType.getTo());
            request.setAttribute("possibleToGroups", this.groupService.search(groupQuery));
        }
        groupQuery = new GroupQuery();
        groupQuery.setNature(Group.Nature.BROKER);
        groupQuery.setStatus(Group.Status.NORMAL);
        groupQuery.setOnlyActive(true);
        request.setAttribute("brokerGroups", this.groupService.search(groupQuery));
        switch (nature) {
            case SIMPLE: {
                return context.findForward("inputSimpleTransactionFee");
            }
            case BROKER: {
                return context.findForward("inputBrokerCommission");
            }
        }
        return null;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        boolean isInsert;
        EditTransactionFeeForm form = (EditTransactionFeeForm)((Object)context.getForm());
        TransactionFee transactionFee = this.retrieveTransactionFee(form);
        boolean bl = isInsert = transactionFee.getId() == null;
        if (transactionFee instanceof BrokerCommission) {
            BrokerCommission brokerCommission = (BrokerCommission)transactionFee;
            transactionFee = this.transactionFeeService.save(brokerCommission);
            context.sendMessage(isInsert ? "brokerCommission.inserted" : "brokerCommission.modified", new Object[0]);
        } else {
            SimpleTransactionFee fee = (SimpleTransactionFee)transactionFee;
            SimpleTransactionFee.ARateRelation aRateRelation = PropertyBinder.instance(SimpleTransactionFee.ARateRelation.class, "aRateRelation").readFromString(form.getTransactionFee());
            transactionFee = this.transactionFeeService.save(fee, aRateRelation);
            context.sendMessage(isInsert ? "transactionFee.inserted" : "transactionFee.modified", new Object[0]);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountTypeId", form.getAccountTypeId());
        params.put("transferTypeId", form.getTransferTypeId());
        params.put("transactionFeeId", transactionFee.getId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditTransactionFeeForm form = (EditTransactionFeeForm)((Object)context.getForm());
        TransactionFee transactionFee = this.retrieveTransactionFee(form);
        if (transactionFee instanceof BrokerCommission) {
            BrokerCommission brokerCommission = (BrokerCommission)transactionFee;
            this.transactionFeeService.validate(brokerCommission);
        } else {
            SimpleTransactionFee simpleFee = (SimpleTransactionFee)transactionFee;
            SimpleTransactionFee.ARateRelation aRateRelation = PropertyBinder.instance(SimpleTransactionFee.ARateRelation.class, "aRateRelation").readFromString(form.getTransactionFee());
            this.transactionFeeService.validate(simpleFee, aRateRelation);
        }
    }

    private void initBasic(BeanBinder<? extends TransactionFee> binder, LocalSettings localSettings) {
        binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
        binder.registerBinder("enabled", PropertyBinder.instance(Boolean.TYPE, "enabled"));
        binder.registerBinder("generatedTransferType", PropertyBinder.instance(TransferType.class, "generatedTransferType"));
        binder.registerBinder("chargeType", PropertyBinder.instance(TransactionFee.ChargeType.class, "chargeType"));
        binder.registerBinder("value", PropertyBinder.instance(BigDecimal.class, "value", localSettings.getHighPrecisionConverter()));
        binder.registerBinder("payer", PropertyBinder.instance(TransactionFee.Subject.class, "payer"));
        binder.registerBinder("initialAmount", PropertyBinder.instance(BigDecimal.class, "initialAmount", localSettings.getNumberConverter()));
        binder.registerBinder("finalAmount", PropertyBinder.instance(BigDecimal.class, "finalAmount", localSettings.getNumberConverter()));
        binder.registerBinder("deductAmount", PropertyBinder.instance(Boolean.TYPE, "deductAmount"));
        binder.registerBinder("fromAllGroups", PropertyBinder.instance(Boolean.TYPE, "fromAllGroups"));
        binder.registerBinder("toAllGroups", PropertyBinder.instance(Boolean.TYPE, "toAllGroups"));
        binder.registerBinder("fromGroups", SimpleCollectionBinder.instance(MemberGroup.class, "fromGroups"));
        binder.registerBinder("toGroups", SimpleCollectionBinder.instance(MemberGroup.class, "toGroups"));
        binder.registerBinder("fromFixedMember", PropertyBinder.instance(Member.class, "fromFixedMember"));
    }

    private TransactionFee retrieveTransactionFee(EditTransactionFeeForm form) {
        TransactionFee.Nature nature;
        try {
            nature = TransactionFee.Nature.valueOf(form.getNature());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        TransactionFee transactionFee = this.getDataBinder(nature).readFromString(form.getTransactionFee());
        transactionFee.setOriginalTransferType(EntityHelper.reference(TransferType.class, form.getTransferTypeId()));
        return transactionFee;
    }
}

