/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.transactionfees;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.accounts.transactionfees.ListGeneratedTypesAjaxForm;
import nl.strohalm.cyclos.controls.accounts.transfertypes.SearchTransferTypesAjaxAction;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.SimpleTransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ListGeneratedTypesAjaxAction
extends SearchTransferTypesAjaxAction {
    private TransactionFeeService transactionFeeService;

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Override
    protected List<TransferType> executeQuery(ActionContext context) {
        try {
            ListGeneratedTypesAjaxForm form = (ListGeneratedTypesAjaxForm)((Object)context.getForm());
            TransferType transferType = this.getTransferTypeService().load(form.getTransferTypeId(), new Relationship[0]);
            TransactionFee.Nature nature = TransactionFee.Nature.valueOf(form.getNature());
            TransactionFee fee = ClassHelper.instantiate(nature.getFeeClass());
            fee.setOriginalTransferType(transferType);
            fee.setPayer(TransactionFee.Subject.valueOf(form.getPayer()));
            switch (nature) {
                case SIMPLE: {
                    ((SimpleTransactionFee)fee).setReceiver(TransactionFee.Subject.valueOf(form.getReceiver()));
                    break;
                }
                case BROKER: {
                    ((BrokerCommission)fee).setWhichBroker(BrokerCommission.WhichBroker.valueOf(form.getWhichBroker()));
                }
            }
            return this.transactionFeeService.searchGeneratedTransferTypes(fee, form.isAllowAnyAccount(), false);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
    }

    @Override
    protected SearchTransferTypesAjaxAction.Options[] resolveOptions(ActionContext context) {
        return new SearchTransferTypesAjaxAction.Options[]{SearchTransferTypesAjaxAction.Options.DIRECTION};
    }
}

