/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.transactionfees;

import java.util.HashMap;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.accounts.transactionfees.RemoveTransactionFeeForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class RemoveTransactionFeeAction
extends BaseAction {
    private TransactionFeeService transactionFeeService;

    public TransactionFeeService getTransactionFeeService() {
        return this.transactionFeeService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        RemoveTransactionFeeForm form = (RemoveTransactionFeeForm)((Object)context.getForm());
        long accountTypeId = form.getAccountTypeId();
        long transferTypeId = form.getTransferTypeId();
        long transactionFeeId = form.getTransactionFeeId();
        if (accountTypeId <= 0L || transferTypeId <= 0L || transactionFeeId <= 0L) {
            throw new ValidationException();
        }
        TransactionFee fee = null;
        try {
            fee = this.transactionFeeService.load(transactionFeeId, new Relationship[0]);
            this.transactionFeeService.remove(transactionFeeId);
            if (fee.getNature() == TransactionFee.Nature.SIMPLE) {
                context.sendMessage("transactionFee.removed", new Object[0]);
            } else {
                context.sendMessage("brokerCommission.removed", new Object[0]);
            }
        }
        catch (Exception e) {
            if (fee.getNature() == TransactionFee.Nature.SIMPLE) {
                context.sendMessage("transactionFee.error.removing", new Object[0]);
            }
            context.sendMessage("brokerCommission.error.removing", new Object[0]);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountTypeId", accountTypeId);
        params.put("transferTypeId", transferTypeId);
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }
}

