/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.transfertypes;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.transfertypes.EditTransferTypeForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.accounts.SystemAccountTypeQuery;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.services.transfertypes.exceptions.HasPendingPaymentsException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts.action.ActionForward;

public class EditTransferTypeAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private AccountTypeService accountTypeService;
    private ChannelService channelService;
    private TransferTypeService transferTypeService;
    private TransactionFeeService transactionFeeService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private DataBinder<TransferType> dataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public AccountTypeService getAccountTypeService() {
        return this.accountTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<TransferType> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<TransferType.Context> contextBinder = BeanBinder.instance(TransferType.Context.class, "context");
                contextBinder.registerBinder("payment", PropertyBinder.instance(Boolean.TYPE, "payment"));
                contextBinder.registerBinder("selfPayment", PropertyBinder.instance(Boolean.TYPE, "selfPayment"));
                BeanBinder<LoanParameters> loanBinder = BeanBinder.instance(LoanParameters.class, "loan");
                loanBinder.registerBinder("type", PropertyBinder.instance(Loan.Type.class, "type"));
                loanBinder.registerBinder("repaymentDays", PropertyBinder.instance(Integer.class, "repaymentDays"));
                loanBinder.registerBinder("repaymentType", PropertyBinder.instance(TransferType.class, "repaymentType"));
                loanBinder.registerBinder("monthlyInterest", PropertyBinder.instance(BigDecimal.class, "monthlyInterest", localSettings.getNumberConverter()));
                loanBinder.registerBinder("monthlyInterestRepaymentType", PropertyBinder.instance(TransferType.class, "monthlyInterestRepaymentType"));
                loanBinder.registerBinder("grantFee", DataBinderHelper.amountConverter("grantFee", localSettings));
                loanBinder.registerBinder("grantFeeRepaymentType", PropertyBinder.instance(TransferType.class, "grantFeeRepaymentType"));
                loanBinder.registerBinder("expirationFee", DataBinderHelper.amountConverter("expirationFee", localSettings));
                loanBinder.registerBinder("expirationFeeRepaymentType", PropertyBinder.instance(TransferType.class, "expirationFeeRepaymentType"));
                loanBinder.registerBinder("expirationDailyInterest", PropertyBinder.instance(BigDecimal.class, "expirationDailyInterest", localSettings.getNumberConverter()));
                loanBinder.registerBinder("expirationDailyInterestRepaymentType", PropertyBinder.instance(TransferType.class, "expirationDailyInterestRepaymentType"));
                BeanBinder<TransferType> binder = BeanBinder.instance(TransferType.class);
                binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
                binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
                binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
                binder.registerBinder("confirmationMessage", PropertyBinder.instance(String.class, "confirmationMessage"));
                binder.registerBinder("context", contextBinder);
                binder.registerBinder("channels", SimpleCollectionBinder.instance(Channel.class, "channels"));
                binder.registerBinder("priority", PropertyBinder.instance(Boolean.TYPE, "priority"));
                binder.registerBinder("from", PropertyBinder.instance(AccountType.class, "from"));
                binder.registerBinder("to", PropertyBinder.instance(AccountType.class, "to"));
                binder.registerBinder("maxAmountPerDay", PropertyBinder.instance(BigDecimal.class, "maxAmountPerDay", localSettings.getNumberConverter()));
                binder.registerBinder("minAmount", PropertyBinder.instance(BigDecimal.class, "minAmount", localSettings.getNumberConverter()));
                binder.registerBinder("conciliable", PropertyBinder.instance(Boolean.TYPE, "conciliable"));
                binder.registerBinder("loan", loanBinder);
                binder.registerBinder("requiresAuthorization", PropertyBinder.instance(Boolean.TYPE, "requiresAuthorization"));
                binder.registerBinder("allowsScheduledPayments", PropertyBinder.instance(Boolean.TYPE, "allowsScheduledPayments"));
                binder.registerBinder("requiresFeedback", PropertyBinder.instance(Boolean.TYPE, "requiresFeedback"));
                binder.registerBinder("feedbackExpirationTime", DataBinderHelper.timePeriodBinder("feedbackExpirationTime"));
                binder.registerBinder("feedbackReplyExpirationTime", DataBinderHelper.timePeriodBinder("feedbackReplyExpirationTime"));
                binder.registerBinder("defaultFeedbackComments", PropertyBinder.instance(String.class, "defaultFeedbackComments"));
                binder.registerBinder("defaultFeedbackLevel", PropertyBinder.instance(Reference.Level.class, "defaultFeedbackLevel"));
                binder.registerBinder("fixedDestinationMember", PropertyBinder.instance(Member.class, "fixedDestinationMember"));
                binder.registerBinder("reserveTotalAmountOnScheduling", PropertyBinder.instance(Boolean.TYPE, "reserveTotalAmountOnScheduling"));
                binder.registerBinder("allowCancelScheduledPayments", PropertyBinder.instance(Boolean.TYPE, "allowCancelScheduledPayments"));
                binder.registerBinder("allowBlockScheduledPayments", PropertyBinder.instance(Boolean.TYPE, "allowBlockScheduledPayments"));
                binder.registerBinder("showScheduledPaymentsToDestination", PropertyBinder.instance(Boolean.TYPE, "showScheduledPaymentsToDestination"));
                binder.registerBinder("allowSmsNotification", PropertyBinder.instance(Boolean.TYPE, "allowSmsNotification"));
                binder.registerBinder("transferListenerClass", PropertyBinder.instance(String.class, "transferListenerClass"));
                binder.registerBinder("transactionHierarchyVisibility", PropertyBinder.instance(TransferType.TransactionHierarchyVisibility.class, "transactionHierarchyVisibility"));
                this.dataBinder = binder;
            }
            DataBinder<TransferType> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditTransferTypeForm form = (EditTransferTypeForm)((Object)context.getForm());
        TransferType transferType = this.retrieveTransferType(form);
        boolean isInsert = transferType.getId() == null;
        try {
            transferType = this.transferTypeService.save(transferType);
        }
        catch (HasPendingPaymentsException e) {
            return context.sendError("transferType.error.hasPendingPayments", new Object[0]);
        }
        context.sendMessage(isInsert ? "transferType.inserted" : "transferType.modified", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountTypeId", form.getAccountTypeId());
        params.put("transferTypeId", transferType.getId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        TransferType transferType;
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditTransferTypeForm form = (EditTransferTypeForm)((Object)context.getForm());
        long accountTypeId = form.getAccountTypeId();
        if (accountTypeId <= 0L) {
            throw new ValidationException();
        }
        AccountType accountType = this.accountTypeService.load(accountTypeId);
        long transferTypeId = form.getTransferTypeId();
        boolean bl = isInsert = transferTypeId <= 0L;
        if (isInsert) {
            transferType = new TransferType();
            transferType.setFrom(accountType);
            transferType.setDefaultFeedbackLevel(Reference.Level.NEUTRAL);
            Channel web = this.channelService.loadByInternalName("web");
            transferType.setChannels(Collections.singleton(web));
            ArrayList<AccountType> accountTypes = new ArrayList<AccountType>();
            SystemAccountTypeQuery systemAccountTypeQuery = new SystemAccountTypeQuery();
            systemAccountTypeQuery.setCurrency(accountType.getCurrency());
            accountTypes.addAll(this.accountTypeService.search(systemAccountTypeQuery));
            MemberAccountTypeQuery memberAccountTypeQuery = new MemberAccountTypeQuery();
            memberAccountTypeQuery.setCurrency(accountType.getCurrency());
            accountTypes.addAll(this.accountTypeService.search(memberAccountTypeQuery));
            if (accountType instanceof SystemAccountType) {
                accountTypes.remove(accountType);
            }
            request.setAttribute("accountTypes", accountTypes);
        } else {
            transferType = this.transferTypeService.load(transferTypeId, TransferType.Relationships.FROM, TransferType.Relationships.TO, TransferType.Relationships.AUTHORIZATION_LEVELS, TransferType.Relationships.CUSTOM_FIELDS);
            this.processAuthorizationLevels(request, transferType);
            GroupQuery query = new GroupQuery();
            query.setNatures(Group.Nature.ADMIN);
            query.setStatus(Group.Status.NORMAL);
            List<? extends Group> adminGroups = this.groupService.search(query);
            request.setAttribute("adminGroups", adminGroups);
            TransactionFeeQuery simpleQuery = new TransactionFeeQuery();
            HashSet<Relationship> fetch = new HashSet<Relationship>();
            fetch.add(RelationshipHelper.nested(TransactionFee.Relationships.GENERATED_TRANSFER_TYPE, TransferType.Relationships.FROM));
            simpleQuery.setFetch(fetch);
            simpleQuery.setNature(TransactionFee.Nature.SIMPLE);
            simpleQuery.setTransferType(transferType);
            simpleQuery.setReturnDisabled(true);
            request.setAttribute("simpleTransactionFees", this.transactionFeeService.search(simpleQuery));
            if (transferType.isFromMember()) {
                TransactionFeeQuery brokerQuery = new TransactionFeeQuery();
                brokerQuery.setNature(TransactionFee.Nature.BROKER);
                brokerQuery.setTransferType(transferType);
                brokerQuery.setReturnDisabled(true);
                request.setAttribute("brokerCommissions", this.transactionFeeService.search(brokerQuery));
            }
            List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, true);
            request.setAttribute("customFields", customFields);
            List<? extends AccountType> linkedFieldAccountTypes = this.accountTypeService.listAll();
            request.setAttribute("linkedFieldAccountTypes", linkedFieldAccountTypes);
        }
        request.setAttribute("transferType", (Object)transferType);
        TransferTypeQuery toSystemRepaymentQuery = new TransferTypeQuery();
        toSystemRepaymentQuery.setContext(TransactionContext.AUTOMATIC);
        toSystemRepaymentQuery.setCurrency(transferType.getCurrency());
        toSystemRepaymentQuery.setFromNature(AccountType.Nature.MEMBER);
        toSystemRepaymentQuery.setToNature(AccountType.Nature.SYSTEM);
        request.setAttribute("loanRepaymentTypes", this.transferTypeService.search(toSystemRepaymentQuery));
        this.getDataBinder().writeAsString(form.getTransferType(), transferType);
        TransferType.Context ttContext = transferType.getContext();
        form.setTransferType("enabled", String.valueOf(ttContext.isPayment() || ttContext.isSelfPayment()));
        request.setAttribute("accountType", (Object)accountType);
        request.setAttribute("isSystemAccount", (Object)(accountType instanceof SystemAccountType));
        request.setAttribute("isInsert", (Object)isInsert);
        RequestHelper.storeEnum(request, Loan.Type.class, "loanTypes");
        RequestHelper.storeEnum(request, Amount.Type.class, "amountTypes");
        RequestHelper.storeEnum(request, AuthorizationLevel.Authorizer.class, "authorizers");
        RequestHelper.storeEnum(request, TransferType.TransactionHierarchyVisibility.class, "transactionHierarchyVisibilities");
        request.setAttribute("feedbackTimeFields", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS));
        request.setAttribute("channels", this.channelService.list());
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditTransferTypeForm form = (EditTransferTypeForm)((Object)context.getForm());
        TransferType transferType = this.retrieveTransferType(form);
        this.transferTypeService.validate(transferType);
    }

    private void processAuthorizationLevels(HttpServletRequest request, TransferType transferType) {
        if (transferType.isRequiresAuthorization()) {
            Collection<AuthorizationLevel> rawAuthorizationLevels = transferType.getAuthorizationLevels();
            LinkedList<AuthorizationLevel> authorizationLevels = new LinkedList<AuthorizationLevel>(rawAuthorizationLevels);
            request.setAttribute("authorizationLevels", authorizationLevels);
            boolean insertNewLevel = false;
            List<AuthorizationLevel.Authorizer> possibleAuthorizers = null;
            if (CollectionUtils.isEmpty(authorizationLevels)) {
                insertNewLevel = true;
                possibleAuthorizers = transferType.isFromSystem() && transferType.isToSystem() ? Arrays.asList(AuthorizationLevel.Authorizer.ADMIN) : (transferType.isFromSystem() && transferType.isToMember() ? Arrays.asList(AuthorizationLevel.Authorizer.ADMIN, AuthorizationLevel.Authorizer.RECEIVER) : (transferType.isToSystem() ? Arrays.asList(AuthorizationLevel.Authorizer.BROKER, AuthorizationLevel.Authorizer.ADMIN) : Arrays.asList(AuthorizationLevel.Authorizer.RECEIVER, AuthorizationLevel.Authorizer.BROKER, AuthorizationLevel.Authorizer.ADMIN)));
            } else {
                RequestHelper.storeEnum(request, AuthorizationLevel.Authorizer.class, "authorizers");
                AuthorizationLevel highestAuthorizationLevel = authorizationLevels.getLast();
                possibleAuthorizers = highestAuthorizationLevel.getAuthorizer() == AuthorizationLevel.Authorizer.RECEIVER ? (transferType.isFromSystem() ? Arrays.asList(AuthorizationLevel.Authorizer.ADMIN, AuthorizationLevel.Authorizer.RECEIVER) : Arrays.asList(AuthorizationLevel.Authorizer.PAYER, AuthorizationLevel.Authorizer.BROKER, AuthorizationLevel.Authorizer.ADMIN)) : Arrays.asList(AuthorizationLevel.Authorizer.ADMIN);
                Integer highestLevel = highestAuthorizationLevel.getLevel();
                insertNewLevel = highestLevel < 5;
            }
            request.setAttribute("insertNewLevel", (Object)insertNewLevel);
            if (insertNewLevel) {
                request.setAttribute("possibleAuthorizers", possibleAuthorizers);
            }
        }
    }

    private TransferType retrieveTransferType(EditTransferTypeForm form) {
        TransferType transferType = this.getDataBinder().readFromString(form.getTransferType());
        transferType.setFrom(this.accountTypeService.load(transferType.getFrom().getId()));
        transferType.setTo(this.accountTypeService.load(transferType.getTo().getId()));
        TransferType.Context context = transferType.getContext();
        if (transferType.isFromSystem() || transferType.isToSystem() || transferType.getFrom().equals(transferType.getTo())) {
            boolean enabled = "true".equals(form.getTransferType("enabled"));
            boolean selfPayment = enabled && transferType.isFromSystem() && transferType.isToSystem();
            boolean payment = enabled && !selfPayment;
            context.setSelfPayment(selfPayment);
            context.setPayment(payment);
        }
        if (transferType.isFromMember() && context.isSelfPayment()) {
            transferType.setChannels(null);
        }
        return transferType;
    }
}

