/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.transfertypes;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.struts.action.ActionForward;

public class PaymentCustomFieldsAjaxAction
extends BaseAction {
    private PaymentCustomFieldService paymentCustomFieldService;
    private TransferTypeService transferTypeService;

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        TransferType transferType = this.resolveTransferType(context);
        if (transferType == null) {
            return null;
        }
        List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, false);
        if (CollectionUtils.isEmpty(customFields)) {
            return null;
        }
        boolean isForLoan = CoercionHelper.coerce(Boolean.TYPE, request.getParameter("forLoan"));
        String fieldName = isForLoan ? "loan(customValues).field" : "customValues.field";
        String valueName = isForLoan ? "loan(customValues).value" : "customValues.value";
        request.setAttribute("isForLoan", (Object)isForLoan);
        request.setAttribute("fieldName", (Object)fieldName);
        request.setAttribute("valueName", (Object)valueName);
        request.setAttribute("columnWidth", ObjectUtils.defaultIfNull((Object)StringHelper.removeMarkupTags(request.getParameter("columnWidth")), (Object)"25%"));
        request.setAttribute("customFields", customFields);
        context.getResponse().setContentType("text/html");
        return new ActionForward("/pages/payments/paymentCustomFields.jsp", false);
    }

    private TransferType resolveTransferType(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        TransferType transferType = CoercionHelper.coerce(TransferType.class, request.getParameter("typeId"));
        if (transferType != null) {
            return transferType;
        }
        AccountType accountType = CoercionHelper.coerce(AccountType.class, request.getParameter("destinationAccountTypeId"));
        Member fromMember = CoercionHelper.coerce(Member.class, request.getParameter("fromId"));
        AccountOwner from = fromMember != null ? fromMember : context.getAccountOwner();
        Member toMember = CoercionHelper.coerce(Member.class, request.getParameter("toId"));
        AccountOwner to = toMember != null ? toMember : context.getAccountOwner();
        TransferTypeQuery query = new TransferTypeQuery();
        query.setUsePriority(true);
        query.setChannel("web");
        query.setFromOwner(from);
        query.setToOwner(to);
        query.setToAccountType(accountType);
        List<TransferType> transferTypes = this.transferTypeService.search(query);
        if (transferTypes.size() == 1) {
            return transferTypes.iterator().next();
        }
        return null;
    }
}

