/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.transfertypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.accounts.transfertypes.SearchTransferTypesAjaxForm;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.AccountOwnerConverter;

public class SearchTransferTypesAjaxAction
extends BaseAjaxAction {
    private DataBinder<TransferTypeQuery> queryBinder;
    protected TransferTypeService transferTypeService;

    public DataBinder<TransferTypeQuery> getQueryBinder() {
        if (this.queryBinder == null) {
            BeanBinder<TransferTypeQuery> binder = BeanBinder.instance(TransferTypeQuery.class);
            binder.registerBinder("channel", PropertyBinder.instance(String.class, "channel"));
            binder.registerBinder("context", PropertyBinder.instance(TransactionContext.class, "context"));
            binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currencyId"));
            binder.registerBinder("fromOwner", PropertyBinder.instance(AccountOwner.class, "fromOwnerId", AccountOwnerConverter.instance()));
            binder.registerBinder("toOwner", PropertyBinder.instance(AccountOwner.class, "toOwnerId", AccountOwnerConverter.instance()));
            binder.registerBinder("fromAccountTypes", SimpleCollectionBinder.instance(AccountType.class, "fromAccountTypeId"));
            binder.registerBinder("toAccountTypes", SimpleCollectionBinder.instance(AccountType.class, "toAccountTypeId"));
            binder.registerBinder("fromGroups", SimpleCollectionBinder.instance(MemberGroup.class, "fromGroups"));
            binder.registerBinder("toGroups", SimpleCollectionBinder.instance(MemberGroup.class, "toGroups"));
            binder.registerBinder("fromOrToGroups", SimpleCollectionBinder.instance(MemberGroup.class, "fromOrToGroups"));
            binder.registerBinder("fromNature", PropertyBinder.instance(AccountType.Nature.class, "fromNature"));
            binder.registerBinder("toNature", PropertyBinder.instance(AccountType.Nature.class, "toNature"));
            this.queryBinder = binder;
        }
        return this.queryBinder;
    }

    public BeanCollectionBinder<Map<String, Object>> getTransferTypeBinder(Options ... opts) {
        BeanBinder<Map<String, Object>> transferTypeBinder = DataBinderHelper.transferTypeBinder();
        List<Object> options = opts == null ? Collections.emptyList() : Arrays.asList(opts);
        if (options.contains((Object)Options.LOAN_DATA)) {
            BeanBinder<Map<String, Object>> loanBinder = DataBinderHelper.loanParametersBinder(this.settingsService.getLocalSettings());
            for (Map.Entry<String, DataBinder<?>> entry : loanBinder.getMappings().entrySet()) {
                DataBinder<?> nestedBinder = entry.getValue();
                nestedBinder.setPath("loan." + nestedBinder.getPath());
                transferTypeBinder.registerBinder(entry.getKey(), nestedBinder);
            }
        }
        if (options.contains((Object)Options.DIRECTION)) {
            transferTypeBinder.registerBinder("fromSystem", PropertyBinder.instance(Boolean.TYPE, "fromSystem"));
            transferTypeBinder.registerBinder("toSystem", PropertyBinder.instance(Boolean.TYPE, "toSystem"));
        }
        if (options.contains((Object)Options.SCHEDULING)) {
            transferTypeBinder.registerBinder("allowsScheduledPayments", PropertyBinder.instance(Boolean.TYPE, "allowsScheduledPayments"));
        }
        if (options.contains((Object)Options.CURRENCY)) {
            transferTypeBinder.registerBinder("currencyId", PropertyBinder.instance(Currency.class, "from.currency"));
        }
        return BeanCollectionBinder.instance(transferTypeBinder);
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    protected List<TransferType> executeQuery(ActionContext context) {
        SearchTransferTypesAjaxForm form = (SearchTransferTypesAjaxForm)((Object)context.getForm());
        TransferTypeQuery query = this.getQueryBinder().readFromString((Object)form);
        AccountOwner fromOwner = query.getFromOwner();
        TransactionContext transactionContext = query.getContext();
        if (transactionContext != TransactionContext.ANY && transactionContext != TransactionContext.AUTOMATIC && transactionContext != TransactionContext.AUTOMATIC_LOAN) {
            if (form.isUseBy() && !context.getAccountOwner().equals(fromOwner) && fromOwner != null) {
                query.setBy((Element)context.getElement());
            } else if (!form.isIgnoreGroup()) {
                if (form.isUseFromGroup() && fromOwner instanceof Member) {
                    Member member = (Member)this.elementService.load(((Member)fromOwner).getId(), Element.Relationships.GROUP);
                    query.setGroup(member.getGroup());
                } else {
                    query.setGroup((Group)context.getGroup());
                }
            }
            query.setUsePriority(!form.isIgnoreGroup());
        }
        return this.transferTypeService.search(query);
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        List<TransferType> transferTypes = this.executeQuery(context);
        String json = this.getTransferTypeBinder(this.resolveOptions(context)).readAsString(transferTypes);
        this.responseHelper.writeJSON(context.getResponse(), json);
    }

    protected Options[] resolveOptions(ActionContext context) {
        SearchTransferTypesAjaxForm form = (SearchTransferTypesAjaxForm)((Object)context.getForm());
        return form.getOptions();
    }

    public static enum Options {
        LOAN_DATA,
        DIRECTION,
        SCHEDULING,
        CURRENCY;

    }
}

