/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.admins;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.admins.AdminProfileForm;
import nl.strohalm.cyclos.controls.elements.ProfileAction;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldService;
import nl.strohalm.cyclos.services.elements.MemberRecordService;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class AdminProfileAction
extends ProfileAction<Administrator> {
    private static final Relationship[] FETCH = new Relationship[]{RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP), RelationshipHelper.nested(User.Relationships.ELEMENT, Administrator.Relationships.CUSTOM_VALUES)};
    private AdminCustomFieldService adminCustomFieldService;
    private MemberRecordService memberRecordService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setAdminCustomFieldService(AdminCustomFieldService adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setMemberRecordService(MemberRecordService memberRecordService) {
        this.memberRecordService = memberRecordService;
    }

    @Override
    protected <CFV extends CustomFieldValue> Class<CFV> getCustomFieldValueClass() {
        return AdminCustomFieldValue.class;
    }

    @Override
    protected Class<Administrator> getElementClass() {
        return Administrator.class;
    }

    @Override
    protected <G extends Group> Class<G> getGroupClass() {
        return AdminGroup.class;
    }

    @Override
    protected <U extends User> Class<U> getUserClass() {
        return AdminUser.class;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        AdminProfileForm form = (AdminProfileForm)((Object)context.getForm());
        Administrator admin = (Administrator)this.getWriteDataBinder(context).readFromString(form.getAdmin());
        Administrator savedAdmin = (Administrator)this.elementService.load(admin.getId(), Element.Relationships.USER);
        admin.getUser().setUsername(savedAdmin.getUsername());
        admin = this.elementService.changeProfile(admin);
        context.sendMessage("profile.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), super.handleSubmit(context), "adminId", admin.getId());
    }

    @Override
    protected DataBinder<Administrator> initDataBinderForWrite(ActionContext context) {
        BeanBinder dataBinder = (BeanBinder)super.initDataBinderForWrite(context);
        BeanBinder<AdminCustomFieldValue> customValueBinder = BeanBinder.instance(AdminCustomFieldValue.class);
        customValueBinder.registerBinder("field", PropertyBinder.instance(AdminCustomField.class, "field", ReferenceConverter.instance(AdminCustomField.class)));
        customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
        BeanCollectionBinder collectionBinder = (BeanCollectionBinder)dataBinder.getMappings().get("customValues");
        collectionBinder.setElementBinder(customValueBinder);
        return dataBinder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        AdminProfileForm form = (AdminProfileForm)((Object)context.getForm());
        boolean myProfile = false;
        AdminUser adminUser = null;
        HttpServletRequest request = context.getRequest();
        Object loggedElement = context.getElement();
        if (form.getAdminId() > 0L && form.getAdminId() != ((Entity)loggedElement).getId().longValue()) {
            Object loaded = this.elementService.loadUser(form.getAdminId(), FETCH);
            if (!(loaded instanceof AdminUser)) throw new ValidationException();
            adminUser = (AdminUser)loaded;
            try {
                request.setAttribute("isLoggedIn", (Object)this.accessService.isLoggedIn(adminUser));
            }
            catch (NotConnectedException e) {}
        } else {
            adminUser = (AdminUser)this.elementService.loadUser(((Entity)context.getUser()).getId(), FETCH);
            myProfile = true;
        }
        Administrator admin = adminUser.getAdministrator();
        this.getReadDataBinder(context).writeAsString(form.getAdmin(), admin);
        List<AdminCustomField> customFields = this.customFieldHelper.onlyForGroup(this.adminCustomFieldService.list(), admin.getAdminGroup());
        boolean editable = myProfile;
        if (!myProfile) {
            editable = this.permissionService.hasPermission(AdminAdminPermission.ADMINS_CHANGE_PROFILE);
            if (this.permissionService.hasPermission(AdminMemberPermission.RECORDS_VIEW)) {
                request.setAttribute("countByRecordType", this.memberRecordService.countByType(admin));
            }
        }
        request.setAttribute("admin", (Object)admin);
        request.setAttribute("disabledLogin", (Object)this.accessService.isLoginBlocked(admin.getUser()));
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(customFields, admin.getCustomValues()));
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("myProfile", (Object)myProfile);
        request.setAttribute("removed", (Object)(admin.getGroup().getStatus() == Group.Status.REMOVED ? 1 : 0));
    }

    @Override
    protected void validateForm(ActionContext context) {
        AdminProfileForm form = (AdminProfileForm)((Object)context.getForm());
        Administrator administrator = (Administrator)this.getWriteDataBinder(context).readFromString(form.getAdmin());
        this.elementService.validate(administrator, WhenSaving.PROFILE, false);
    }
}

