/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.admins;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.admins.CreateAdminForm;
import nl.strohalm.cyclos.controls.elements.CreateElementAction;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldService;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class CreateAdminAction
extends CreateElementAction<Administrator> {
    private AdminCustomFieldService adminCustomFieldService;
    private CustomFieldHelper customFieldHelper;

    public AdminCustomFieldService getAdminCustomFieldService() {
        return this.adminCustomFieldService;
    }

    @Inject
    public void setAdminCustomFieldService(AdminCustomFieldService adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Override
    protected ActionForward create(Element element, ActionContext context) {
        ActionForward forward;
        Long paramValue;
        String paramName;
        CreateAdminForm form = (CreateAdminForm)((Object)context.getForm());
        Administrator administrator = (Administrator)element;
        administrator = (Administrator)this.elementService.register(administrator, form.isForceChangePassword(), context.getRequest().getRemoteAddr());
        if (form.isOpenProfile()) {
            paramName = "adminId";
            paramValue = administrator.getId();
            forward = context.findForward("profile");
        } else {
            context.sendMessage("createAdmin.created", new Object[0]);
            paramName = "groupId";
            paramValue = administrator.getGroup().getId();
            forward = context.findForward("new");
        }
        return ActionHelper.redirectWithParam(context.getRequest(), forward, paramName, paramValue);
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        super.formAction(context);
        context.sendMessage("createAdmin.created", new Object[0]);
    }

    @Override
    protected Class<AdminCustomField> getCustomFieldClass() {
        return AdminCustomField.class;
    }

    @Override
    protected Class<AdminCustomFieldValue> getCustomFieldValueClass() {
        return AdminCustomFieldValue.class;
    }

    @Override
    protected Class<Administrator> getElementClass() {
        return Administrator.class;
    }

    @Override
    protected Class<AdminGroup> getGroupClass() {
        return AdminGroup.class;
    }

    @Override
    protected Class<AdminUser> getUserClass() {
        return AdminUser.class;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        CreateAdminForm form = (CreateAdminForm)((Object)context.getForm());
        long groupId = form.getGroupId();
        if (groupId <= 0L) {
            throw new ValidationException();
        }
        AdminGroup group = (AdminGroup)this.groupService.load(groupId, new Relationship[0]);
        List<AdminCustomField> customFields = this.customFieldHelper.onlyForGroup(this.adminCustomFieldService.list(), group);
        request.setAttribute("customFields", customFields);
        request.setAttribute("group", (Object)group);
    }

    @Override
    protected void runValidation(ActionContext context, Element element) {
        this.elementService.validate(element, WhenSaving.ADMIN_BY_ADMIN, true);
    }
}

