/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.admins;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.SearchElementsAction;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.members.FullTextAdminQuery;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchAdminsAction
extends SearchElementsAction<FullTextAdminQuery> {
    @Override
    protected Class<? extends CustomFieldValue> getCustomFieldValueClass() {
        return AdminCustomFieldValue.class;
    }

    @Override
    protected Class<FullTextAdminQuery> getQueryClass() {
        return FullTextAdminQuery.class;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        FullTextAdminQuery query = (FullTextAdminQuery)super.prepareForm(context);
        HttpServletRequest request = context.getRequest();
        GroupQuery groupQuery = new GroupQuery();
        groupQuery.setNatures(Group.Nature.ADMIN);
        request.setAttribute("groups", this.groupService.search(groupQuery));
        if (this.permissionService.hasPermission(AdminAdminPermission.ADMINS_REGISTER)) {
            GroupQuery possibleGroupQuery = new GroupQuery();
            possibleGroupQuery.setNatures(Group.Nature.ADMIN);
            possibleGroupQuery.setStatus(Group.Status.NORMAL);
            request.setAttribute("possibleNewGroups", this.groupService.search(possibleGroupQuery));
        }
        return query;
    }
}

