/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.admins.mailPreferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.admins.mailPreferences.MailPreferencesForm;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeTypeQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.preferences.AdminNotificationPreference;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeService;
import nl.strohalm.cyclos.services.preferences.PreferenceService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;

public class MailPreferencesAction
extends BaseFormAction {
    private GuaranteeTypeService guaranteeTypeService;
    private PreferenceService preferenceService;
    private TransferTypeService transferTypeService;
    private DataBinder<AdminNotificationPreference> dataBinder;

    @Inject
    public void setGuaranteeTypeService(GuaranteeTypeService guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    @Inject
    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        MailPreferencesForm form = (MailPreferencesForm)((Object)context.getForm());
        AdminNotificationPreference notificationPreference = this.getDataBinder().readFromString(form.getAdminNotificationPreference());
        notificationPreference = this.preferenceService.save(notificationPreference);
        context.sendMessage("mailPreferences.saved", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        MailPreferencesForm form = (MailPreferencesForm)((Object)context.getForm());
        Administrator admin = (Administrator)context.getElement();
        AdminGroup group = admin.getAdminGroup();
        group = (AdminGroup)this.groupService.load(group.getId(), AdminGroup.Relationships.VIEW_INFORMATION_OF, SystemGroup.Relationships.MESSAGE_CATEGORIES);
        ArrayList<MemberGroup> memberGroups = new ArrayList<MemberGroup>(this.permissionService.getManagedMemberGroups());
        Iterator it = memberGroups.iterator();
        while (it.hasNext()) {
            if (!((MemberGroup)it.next()).isRemoved()) continue;
            it.remove();
        }
        Collections.sort(memberGroups);
        List<TransferType> transferTypes = this.transferTypeService.getPaymentAndSelfPaymentTTs();
        List<TransferType> newPendingPayments = this.transferTypeService.getAuthorizableTTs();
        List<Object> guaranteeTypes = Collections.emptyList();
        if (this.permissionService.hasPermission(AdminSystemPermission.GUARANTEE_TYPES_VIEW)) {
            GuaranteeTypeQuery guaranteeTypeQuery = new GuaranteeTypeQuery();
            guaranteeTypeQuery.setEnabled(true);
            guaranteeTypes = this.guaranteeTypeService.search(guaranteeTypeQuery);
        }
        ArrayList<MessageCategory> messageCategories = new ArrayList<MessageCategory>(group.getMessageCategories());
        Collections.sort(messageCategories);
        AdminNotificationPreference notificationPreference = null;
        try {
            notificationPreference = this.preferenceService.load(admin, AdminNotificationPreference.Relationships.TRANSFER_TYPES, AdminNotificationPreference.Relationships.MESSAGE_CATEGORIES, AdminNotificationPreference.Relationships.MEMBER_ALERTS, AdminNotificationPreference.Relationships.SYSTEM_ALERTS);
            form.setAdminNotificationPreference("applicationErrors", notificationPreference.isApplicationErrors());
            form.setAdminNotificationPreference("systemInvoices", notificationPreference.isSystemInvoices());
            request.setAttribute("selectedTransferTypes", notificationPreference.getTransferTypes());
            request.setAttribute("selectedNewPendingPayments", notificationPreference.getNewPendingPayments());
            request.setAttribute("selectedGuaranteeTypes", notificationPreference.getGuaranteeTypes());
            request.setAttribute("selectedMessageCategories", notificationPreference.getMessageCategories());
            request.setAttribute("selectedNewMembers", notificationPreference.getNewMembers());
            request.setAttribute("selectedSystemAlerts", notificationPreference.getSystemAlerts());
            request.setAttribute("selectedMemberAlerts", notificationPreference.getMemberAlerts());
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        RequestHelper.storeEnum(request, MemberAlert.Alerts.class, "memberAlerts");
        RequestHelper.storeEnum(request, SystemAlert.Alerts.class, "systemAlerts");
        request.setAttribute("transferTypes", transferTypes);
        request.setAttribute("newPendingPayments", newPendingPayments);
        request.setAttribute("guaranteeTypes", guaranteeTypes);
        request.setAttribute("messageCategories", messageCategories);
        request.setAttribute("memberGroups", memberGroups);
        request.setAttribute("notificationPreference", (Object)notificationPreference);
    }

    private DataBinder<AdminNotificationPreference> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<AdminNotificationPreference> binder = BeanBinder.instance(AdminNotificationPreference.class);
            binder.registerBinder("transferTypes", SimpleCollectionBinder.instance(TransferType.class, Set.class, "transferTypes"));
            binder.registerBinder("newPendingPayments", SimpleCollectionBinder.instance(TransferType.class, Set.class, "newPendingPayments"));
            binder.registerBinder("messageCategories", SimpleCollectionBinder.instance(MessageCategory.class, Set.class, "messageCategories"));
            binder.registerBinder("guaranteeTypes", SimpleCollectionBinder.instance(GuaranteeType.class, Set.class, "guaranteeTypes"));
            binder.registerBinder("newMembers", SimpleCollectionBinder.instance(MemberGroup.class, Set.class, "newMembers"));
            binder.registerBinder("systemAlerts", SimpleCollectionBinder.instance(SystemAlert.Alerts.class, Set.class, "systemAlerts"));
            binder.registerBinder("memberAlerts", SimpleCollectionBinder.instance(MemberAlert.Alerts.class, Set.class, "memberAlerts"));
            binder.registerBinder("applicationErrors", PropertyBinder.instance(Boolean.TYPE, "applicationErrors"));
            binder.registerBinder("systemInvoices", PropertyBinder.instance(Boolean.TYPE, "systemInvoices"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

