/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.admintasks;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.entities.IndexStatus;
import nl.strohalm.cyclos.entities.Indexable;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.application.ApplicationService;
import nl.strohalm.cyclos.utils.ClassHelper;
import org.apache.struts.action.ActionForward;

public class AdministrativeTasksAction
extends BaseAction {
    private ApplicationService applicationService;

    @Inject
    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        boolean canViewIndexes = this.permissionService.hasPermission(AdminSystemPermission.TASKS_MANAGE_INDEXES);
        if (canViewIndexes) {
            Map<Class<? extends Indexable>, IndexStatus> indexesStatus = this.applicationService.getFullTextIndexesStatus();
            LinkedHashMap<String, IndexStatus> indexesStatusAsString = new LinkedHashMap<String, IndexStatus>();
            boolean allOptimized = true;
            for (Map.Entry<Class<? extends Indexable>, IndexStatus> entry : indexesStatus.entrySet()) {
                boolean optimized;
                String name = ClassHelper.getClassName(entry.getKey());
                IndexStatus status = entry.getValue();
                boolean bl = optimized = status == IndexStatus.ACTIVE;
                if (!optimized) {
                    allOptimized = false;
                }
                indexesStatusAsString.put(name, status);
            }
            request.setAttribute("allOptimized", (Object)allOptimized);
            request.setAttribute("indexesStatus", indexesStatusAsString);
        }
        request.setAttribute("canViewIndexes", (Object)canViewIndexes);
        boolean canManageOnlineState = this.permissionService.hasPermission(AdminSystemPermission.TASKS_ONLINE_STATE);
        if (canManageOnlineState) {
            boolean systemOnline = this.applicationService.isOnline();
            request.setAttribute("systemOnline", (Object)systemOnline);
        }
        request.setAttribute("canManageOnlineState", (Object)canManageOnlineState);
        if (!canViewIndexes && !canManageOnlineState) {
            throw new PermissionDeniedException();
        }
        return context.getInputForward();
    }
}

