/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.ads.AdForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.images.OwneredImage;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.ads.AdCategoryService;
import nl.strohalm.cyclos.services.ads.AdService;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public abstract class BaseAdAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private static final Relationship[] FETCH = new Relationship[]{RelationshipHelper.nested(Ad.Relationships.CATEGORY, RelationshipHelper.nested(3, (Relationship)AdCategory.Relationships.PARENT)), RelationshipHelper.nested(Ad.Relationships.OWNER, Element.Relationships.USER), RelationshipHelper.nested(Ad.Relationships.OWNER, Element.Relationships.GROUP), Ad.Relationships.CUSTOM_VALUES, Ad.Relationships.IMAGES, Ad.Relationships.CURRENCY};
    private AdService adService;
    private AdCategoryService adCategoryService;
    private AdCustomFieldService adCustomFieldService;
    private ImageService imageService;
    private DataBinder<Ad> readDataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private CustomFieldHelper customFieldHelper;

    public AdCategoryService getAdCategoryService() {
        return this.adCategoryService;
    }

    public AdCustomFieldService getAdCustomFieldService() {
        return this.adCustomFieldService;
    }

    public AdService getAdService() {
        return this.adService;
    }

    public ImageService getImageService() {
        return this.imageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<Ad> getReadDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.readDataBinder == null) {
                LocalSettings settings = this.settingsService.getLocalSettings();
                BeanBinder<Ad> binder = BeanBinder.instance(Ad.class);
                binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
                binder.registerBinder("owner", PropertyBinder.instance(Member.class, "owner", ReferenceConverter.instance(Member.class)));
                binder.registerBinder("tradeType", PropertyBinder.instance(Ad.TradeType.class, "tradeType"));
                binder.registerBinder("category", PropertyBinder.instance(AdCategory.class, "category", ReferenceConverter.instance(AdCategory.class)));
                binder.registerBinder("title", PropertyBinder.instance(String.class, "title"));
                binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
                binder.registerBinder("html", PropertyBinder.instance(Boolean.TYPE, "html"));
                binder.registerBinder("externalPublication", PropertyBinder.instance(Boolean.TYPE, "externalPublication"));
                binder.registerBinder("permanent", PropertyBinder.instance(Boolean.TYPE, "permanent"));
                binder.registerBinder("publicationPeriod", DataBinderHelper.rawPeriodBinder(settings, "publicationPeriod"));
                binder.registerBinder("price", PropertyBinder.instance(BigDecimal.class, "price", settings.getNumberConverter()));
                binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
                this.readDataBinder = binder;
            }
            DataBinder<Ad> dataBinder = this.readDataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.readDataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setAdCategoryService(AdCategoryService adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    @Inject
    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Inject
    public void setAdService(AdService adService) {
        this.adService = adService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        AdForm form = (AdForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        Ad ad = this.resolveAd(context);
        boolean editable = this.adService.isEditable(ad);
        this.getReadDataBinder().writeAsString(form.getAd(), ad);
        boolean maxImages = false;
        request.setAttribute("ad", (Object)ad);
        List<AdCustomField> customFields = this.adCustomFieldService.list();
        customFields = this.customFieldHelper.onlyForAdsSearch(customFields);
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(customFields, ad.getCustomValues()));
        if (ad.isPersistent()) {
            List<? extends OwneredImage> images = this.imageService.listByOwner(ad);
            MemberGroupSettings groupSettings = ad.getOwner().getMemberGroup().getMemberSettings();
            maxImages = groupSettings == null ? true : images.size() >= groupSettings.getMaxAdImagesPerMember();
            request.setAttribute("images", images);
        }
        request.setAttribute("maxImages", (Object)maxImages);
        request.setAttribute("editable", (Object)editable);
        if (editable) {
            ArrayList<AdCategory> leafCategories = new ArrayList<AdCategory>(this.adCategoryService.listLeaf());
            ArrayList<AdCategory> categories = new ArrayList<AdCategory>();
            Iterator iterator = leafCategories.iterator();
            while (iterator.hasNext()) {
                AdCategory category = (AdCategory)iterator.next();
                if (!category.isRoot() || !category.isLeaf()) continue;
                iterator.remove();
                categories.add(category);
            }
            categories.addAll(leafCategories);
            request.setAttribute("categories", categories);
            RequestHelper.storeEnum(request, Ad.TradeType.class, "tradeTypes");
        }
    }

    protected Ad resolveAd(ActionContext context) throws Exception {
        AdForm form = (AdForm)((Object)context.getForm());
        if (form.getId() <= 0L) {
            throw new ValidationException();
        }
        return this.adService.load(form.getId(), FETCH);
    }
}

