/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.ads.AdForm;
import nl.strohalm.cyclos.controls.ads.BaseAdAction;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.TextFormat;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.conversion.StringTrimmerConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class EditAdAction
extends BaseAdAction {
    private AccountTypeService accountTypeService;
    private CurrencyService currencyService;
    private DataBinder<Ad> writeDataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<Ad> getWriteDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.writeDataBinder == null) {
                LocalSettings settings = this.settingsService.getLocalSettings();
                BeanBinder<AdCustomFieldValue> customValueBinder = BeanBinder.instance(AdCustomFieldValue.class);
                customValueBinder.registerBinder("field", PropertyBinder.instance(AdCustomField.class, "field", ReferenceConverter.instance(AdCustomField.class)));
                customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
                BeanBinder<Ad> binder = BeanBinder.instance(Ad.class);
                binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
                binder.registerBinder("owner", PropertyBinder.instance(Member.class, "owner", ReferenceConverter.instance(Member.class)));
                binder.registerBinder("tradeType", PropertyBinder.instance(Ad.TradeType.class, "tradeType"));
                binder.registerBinder("category", PropertyBinder.instance(AdCategory.class, "category", ReferenceConverter.instance(AdCategory.class)));
                binder.registerBinder("title", PropertyBinder.instance(String.class, "title"));
                binder.registerBinder("externalPublication", PropertyBinder.instance(Boolean.TYPE, "externalPublication"));
                binder.registerBinder("permanent", PropertyBinder.instance(Boolean.TYPE, "permanent"));
                binder.registerBinder("publicationPeriod", DataBinderHelper.rawPeriodBinder(settings, "publicationPeriod"));
                binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
                binder.registerBinder("price", PropertyBinder.instance(BigDecimal.class, "price", settings.getNumberConverter()));
                binder.registerBinder("html", PropertyBinder.instance(Boolean.TYPE, "html"));
                binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
                this.writeDataBinder = binder;
            }
            DataBinder<Ad> dataBinder = this.writeDataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            super.onLocalSettingsUpdate(event);
            this.writeDataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    protected Member getMember(ActionContext context) {
        Member member;
        AdForm form = (AdForm)((Object)context.getForm());
        long adId = form.getId();
        if (adId > 0L) {
            return this.getAdService().load(adId, Ad.Relationships.OWNER).getOwner();
        }
        Object loggedElement = context.getElement();
        if (form.getMemberId() <= 0L || form.getMemberId() == ((Entity)loggedElement).getId().longValue()) {
            if (context.isAdmin()) {
                throw new ValidationException();
            }
            member = context.isOperator() ? ((Operator)context.getElement()).getMember() : (Member)context.getElement();
        } else {
            Object element = this.elementService.load(form.getMemberId(), Element.Relationships.USER);
            if (!(element instanceof Member)) {
                throw new ValidationException();
            }
            member = (Member)element;
        }
        member = (Member)this.elementService.load(member.getId(), Element.Relationships.GROUP);
        return member;
    }

    protected int getNumberOfAds(Member member) {
        Map<Ad.Status, Integer> adMap = this.getAdService().getNumberOfAds(null, member);
        Collection<Integer> values = adMap.values();
        int totalAds = 0;
        for (Integer i : values) {
            totalAds += i.intValue();
        }
        return totalAds;
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        TextFormat descriptionFormat;
        HttpServletRequest request = context.getRequest();
        AdForm form = (AdForm)((Object)context.getForm());
        ActionForward forward = super.handleDisplay(context);
        Ad ad = (Ad)request.getAttribute("ad");
        if (ad.isTransient()) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            descriptionFormat = localSettings.getAdDescriptionFormat();
            form.setAd("html", descriptionFormat == TextFormat.RICH);
        } else {
            descriptionFormat = ad.isHtml() ? TextFormat.RICH : TextFormat.PLAIN;
        }
        request.setAttribute("descriptionFormat", (Object)descriptionFormat);
        boolean editable = (Boolean)request.getAttribute("editable");
        MemberGroup memberGroup = ad.getOwner().getMemberGroup();
        List<Currency> currencies = this.currencyService.listByMemberGroup(memberGroup);
        request.setAttribute("currencies", currencies);
        if (editable) {
            MemberAccountType defaultAccountType;
            if (currencies.size() == 1) {
                request.setAttribute("singleCurrency", (Object)currencies.get(0));
            } else if (currencies.size() > 1 && ad.getCurrency() == null && (defaultAccountType = this.accountTypeService.getDefault(memberGroup, AccountType.Relationships.CURRENCY)) != null) {
                form.setAd("currency", CoercionHelper.coerce(String.class, defaultAccountType.getCurrency()));
            }
            Member member = this.getMember(context);
            MemberGroupSettings memberSettings = member.getMemberGroup().getMemberSettings();
            int adCount = this.getNumberOfAds(member);
            int maxAdsPerMember = memberSettings.getMaxAdsPerMember();
            boolean maxAds = adCount >= maxAdsPerMember;
            request.setAttribute("maxAds", (Object)maxAds);
            request.setAttribute("enablePermanent", (Object)memberSettings.isEnablePermanentAds());
            request.setAttribute("enableExternalPublication", (Object)(memberSettings.getExternalAdPublication() == MemberGroupSettings.ExternalAdPublication.ALLOW_CHOICE ? 1 : 0));
            return forward;
        }
        request.setAttribute("singleCurrency", currencies.isEmpty() ? null : currencies.get(0));
        return ActionHelper.redirectWithParam(request, context.findForward("view"), "id", form.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        AdForm form = (AdForm)((Object)context.getForm());
        Ad ad = this.readAd(context);
        boolean isInsert = ad.isTransient();
        ad = this.getAdService().save(ad);
        FormFile upload = form.getPicture();
        if (upload != null && upload.getFileSize() > 0) {
            try {
                StringBuffer newFileName = new StringBuffer(upload.getFileName());
                if (upload.getFileName().length() > 100) {
                    newFileName = new StringBuffer();
                    String name = upload.getFileName();
                    int extensionPos = name.lastIndexOf(".");
                    String extension = name.substring(extensionPos);
                    newFileName.append(name.substring(0, 100 - extension.length()));
                    newFileName.append(extension);
                }
                this.getImageService().save(ad, form.getPictureCaption(), ImageHelper.ImageType.getByContentType(upload.getContentType()), newFileName.toString(), upload.getInputStream());
            }
            finally {
                upload.destroy();
            }
        }
        context.sendMessage(isInsert ? "ad.inserted" : "ad.modified", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", ad.getId());
        params.put("memberId", ad.getOwner().getId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected Ad resolveAd(ActionContext context) throws Exception {
        Member member;
        AdForm form = (AdForm)((Object)context.getForm());
        if (form.getId() > 0L) {
            return super.resolveAd(context);
        }
        Object loggedElement = context.getElement();
        if (form.getMemberId() > 0L && form.getMemberId() != ((Entity)loggedElement).getId().longValue()) {
            Object element = this.elementService.load(form.getMemberId(), Element.Relationships.GROUP);
            if (!(element instanceof Member)) {
                throw new ValidationException();
            }
            member = (Member)element;
        } else {
            if (context.isAdmin()) {
                throw new ValidationException();
            }
            member = context.isMember() ? (Member)context.getElement() : ((Operator)context.getElement()).getMember();
        }
        MemberGroup group = member.getMemberGroup();
        MemberGroupSettings settings = group.getMemberSettings();
        TimePeriod defaultPublicationTime = settings == null ? null : settings.getDefaultAdPublicationTime();
        Ad ad = new Ad();
        ad.setOwner(member);
        ad.setTradeType(Ad.TradeType.OFFER);
        Calendar today = Calendar.getInstance();
        ad.setPublicationPeriod(Period.between(today, defaultPublicationTime.add(today)));
        return ad;
    }

    @Override
    protected void validateForm(ActionContext context) {
        Ad ad = this.readAd(context);
        this.getAdService().validate(ad);
    }

    private Ad readAd(ActionContext context) {
        AdForm form = (AdForm)((Object)context.getForm());
        Ad ad = this.getWriteDataBinder().readFromString(form.getAd());
        if (ad.isHtml()) {
            ad.setDescription(HtmlConverter.instance().valueOf("" + form.getAd("description")));
        } else {
            ad.setDescription(StringTrimmerConverter.instance().valueOf("" + form.getAd("description")));
        }
        if (ad.getOwner() == null) {
            if (context.isMember()) {
                ad.setOwner((Member)context.getElement());
            } else if (context.isOperator()) {
                Operator operator = (Operator)context.getElement();
                ad.setOwner(operator.getMember());
            }
        }
        return ad;
    }
}

