/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.ads.SearchAdsAction;
import nl.strohalm.cyclos.controls.ads.SearchAdsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.FullTextAdQuery;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.ads.AdService;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.CustomFieldConverter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ExportAdsToCsvAction
extends BaseCsvAction {
    private AdService adService;
    private AdCustomFieldService adCustomFieldService;
    private DataBinder<FullTextAdQuery> dataBinder;

    public AdCustomFieldService getAdCustomFieldService() {
        return this.adCustomFieldService;
    }

    public AdService getAdService() {
        return this.adService;
    }

    public DataBinder<FullTextAdQuery> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = SearchAdsAction.adFullTextQueryDataBinder(this.settingsService.getLocalSettings());
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Inject
    public void setAdService(AdService adService) {
        this.adService = adService;
    }

    protected List<?> executeQuery(ActionContext context) {
        SearchAdsForm form = (SearchAdsForm)((Object)context.getForm());
        FullTextAdQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.fetch(RelationshipHelper.nested(Ad.Relationships.CATEGORY, RelationshipHelper.nested(3, (Relationship)AdCategory.Relationships.PARENT)), Ad.Relationships.CURRENCY, Ad.Relationships.CUSTOM_VALUES, RelationshipHelper.nested(Ad.Relationships.OWNER, Element.Relationships.USER));
        return this.adService.fullTextSearch(query);
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "ads_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter resolveCSVWriter(ActionContext context) {
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<Ad> csv = CSVWriter.instance(Ad.class, settings);
        csv.addColumn(context.message("ad.id", new Object[0]), "id");
        csv.addColumn(context.message("ad.tradeType", new Object[0]), "tradeType", this.messageHelper.getMessageConverter(this.getServlet().getServletContext(), "ad.tradeType."));
        csv.addColumn(context.message("ad.title", new Object[0]), "title");
        csv.addColumn(context.message("ad.category", new Object[0]), "category.fullName");
        csv.addColumn(context.message("ad.price", new Object[0]), "price", settings.getNumberConverter());
        csv.addColumn(context.message("accountType.currency", new Object[0]), "currency.symbol");
        csv.addColumn(context.message("ad.permanent", new Object[0]), "permanent");
        csv.addColumn(context.message("ad.publicationPeriod.begin", new Object[0]), "publicationPeriod.begin", settings.getRawDateConverter());
        csv.addColumn(context.message("ad.publicationPeriod.end", new Object[0]), "publicationPeriod.end", settings.getRawDateConverter());
        csv.addColumn(context.message("member.username", new Object[0]), "owner.username");
        csv.addColumn(context.message("ad.owner", new Object[0]), "owner.name");
        csv.addColumn(context.message("ad.externalPublication", new Object[0]), "externalPublication");
        csv.addColumn(context.message("ad.description", new Object[0]), "description");
        List customFields = this.adCustomFieldService.list();
        for (AdCustomField field : customFields) {
            csv.addColumn(field.getName(), "customValues", new CustomFieldConverter(field, this.elementService, settings));
        }
        return csv;
    }
}

