/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.ads.MemberAdsForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.entities.customization.images.AdImage;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.ads.AdService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class MemberAdsAction
extends BaseAction {
    private AdService adService;

    public AdService getAdService() {
        return this.adService;
    }

    @Inject
    public void setAdService(AdService adService) {
        this.adService = adService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        Member member;
        MemberAdsForm form = (MemberAdsForm)((Object)context.getForm());
        boolean myAds = false;
        boolean editable = false;
        boolean brokerViewingAsMember = form.isReadOnly();
        if (form.getMemberId() <= 0L || form.getMemberId() == ((Entity)context.getElement()).getId().longValue() || context.isOperator() && form.getMemberId() == ((Operator)context.getElement()).getMember().getId().longValue()) {
            if (context.isMember()) {
                member = (Member)context.getElement();
                editable = this.permissionService.hasPermission(MemberPermission.ADS_PUBLISH);
            } else if (context.isOperator()) {
                member = ((Operator)context.getElement()).getMember();
                editable = this.permissionService.hasPermission(OperatorPermission.ADS_PUBLISH);
            } else {
                throw new ValidationException();
            }
            myAds = true;
        } else {
            Object element = this.elementService.load(form.getMemberId(), Element.Relationships.USER);
            if (!(element instanceof Member)) {
                throw new ValidationException();
            }
            member = (Member)element;
            if (context.isMember()) {
                editable = !brokerViewingAsMember && context.isBrokerOf(member) && this.permissionService.hasPermission(BrokerPermission.ADS_MANAGE);
            } else if (context.isAdmin()) {
                editable = this.permissionService.hasPermission(AdminMemberPermission.ADS_MANAGE);
            }
        }
        AdQuery query = new AdQuery();
        query.fetch(RelationshipHelper.nested(Ad.Relationships.OWNER, Element.Relationships.USER), Ad.Relationships.CURRENCY);
        query.setMyAds(myAds);
        query.setOwner(member);
        if (!(context.isAdmin() || myAds || context.isBrokerOf(member))) {
            query.setStatus(Ad.Status.ACTIVE);
        }
        if (brokerViewingAsMember) {
            query.setStatus(Ad.Status.ACTIVE);
        }
        List<Ad> ads = this.adService.search(query);
        boolean hasImages = false;
        for (Ad ad : ads) {
            Collection<AdImage> images = ad.getImages();
            if (images == null || images.isEmpty()) continue;
            hasImages = true;
            break;
        }
        member = (Member)this.elementService.load(member.getId(), Element.Relationships.GROUP);
        int adCount = ads.size();
        int maxAdsPerMember = member.getMemberGroup().getMemberSettings().getMaxAdsPerMember();
        HttpServletRequest request = context.getRequest();
        request.setAttribute("member", (Object)member);
        request.setAttribute("hasImages", (Object)hasImages);
        request.setAttribute("myAds", (Object)myAds);
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("ads", ads);
        request.setAttribute("readOnly", (Object)brokerViewingAsMember);
        request.setAttribute("maxAds", (Object)(adCount >= maxAdsPerMember ? 1 : 0));
        return context.getInputForward();
    }
}

