/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.ads.SearchAdsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.ads.AbstractAdQuery;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.AdCategoryWithCounterQuery;
import nl.strohalm.cyclos.entities.ads.AdCategoryWithCounterVO;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.entities.ads.FullTextAdQuery;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.ads.AdCategoryService;
import nl.strohalm.cyclos.services.ads.AdService;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;

public class SearchAdsAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);
    protected AdService adService;
    protected AdCategoryService adCategoryService;
    protected AdCustomFieldService adCustomFieldService;
    protected MemberCustomFieldService memberCustomFieldService;
    protected GroupFilterService groupFilterService;
    protected CurrencyService currencyService;
    private DataBinder<FullTextAdQuery> dataBinder;
    private CustomFieldHelper customFieldHelper;

    public static DataBinder<FullTextAdQuery> adFullTextQueryDataBinder(LocalSettings settings) {
        BeanBinder<AdCustomFieldValue> adCustomValueBinder = BeanBinder.instance(AdCustomFieldValue.class);
        adCustomValueBinder.registerBinder("field", PropertyBinder.instance(AdCustomField.class, "field", ReferenceConverter.instance(AdCustomField.class)));
        adCustomValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        BeanBinder<MemberCustomFieldValue> memberCustomValueBinder = BeanBinder.instance(MemberCustomFieldValue.class);
        memberCustomValueBinder.registerBinder("field", PropertyBinder.instance(MemberCustomField.class, "field", ReferenceConverter.instance(MemberCustomField.class)));
        memberCustomValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        BeanBinder<FullTextAdQuery> binder = BeanBinder.instance(FullTextAdQuery.class);
        binder.registerBinder("groupFilters", SimpleCollectionBinder.instance(GroupFilter.class, "groupFilters"));
        binder.registerBinder("groups", SimpleCollectionBinder.instance(MemberGroup.class, "groups"));
        binder.registerBinder("tradeType", PropertyBinder.instance(Ad.TradeType.class, "tradeType"));
        binder.registerBinder("status", PropertyBinder.instance(Ad.Status.class, "status"));
        binder.registerBinder("keywords", PropertyBinder.instance(String.class, "keywords"));
        binder.registerBinder("category", PropertyBinder.instance(AdCategory.class, "category", ReferenceConverter.instance(AdCategory.class)));
        binder.registerBinder("since", DataBinderHelper.timePeriodBinder("since"));
        binder.registerBinder("initialPrice", PropertyBinder.instance(BigDecimal.class, "initialPrice", settings.getNumberConverter()));
        binder.registerBinder("finalPrice", PropertyBinder.instance(BigDecimal.class, "finalPrice", settings.getNumberConverter()));
        binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
        binder.registerBinder("withImagesOnly", PropertyBinder.instance(Boolean.TYPE, "withImagesOnly"));
        binder.registerBinder("adValues", BeanCollectionBinder.instance(adCustomValueBinder, "adValues"));
        binder.registerBinder("memberValues", BeanCollectionBinder.instance(memberCustomValueBinder, "memberValues"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    public AdCategoryService getAdCategoryService() {
        return this.adCategoryService;
    }

    public AdCustomFieldService getAdCustomFieldService() {
        return this.adCustomFieldService;
    }

    public AdService getAdService() {
        return this.adService;
    }

    public GroupFilterService getGroupFilterService() {
        return this.groupFilterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            super.onLocalSettingsUpdate(event);
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setAdCategoryService(AdCategoryService adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    @Inject
    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Inject
    public void setAdService(AdService adService) {
        this.adService = adService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        AbstractAdQuery query;
        HttpServletRequest request = context.getRequest();
        List<Ad> ads = null;
        if (queryParameters instanceof AdQuery) {
            query = (AdQuery)queryParameters;
            ads = this.adService.search((AdQuery)query);
        } else {
            query = (FullTextAdQuery)queryParameters;
            ads = this.adService.fullTextSearch((FullTextAdQuery)query);
        }
        request.setAttribute("ads", ads);
        SearchAdsForm form = (SearchAdsForm)((Object)context.getForm());
        form.setAlreadySearched(true);
    }

    @Override
    protected AbstractAdQuery prepareForm(ActionContext context) {
        AdCategory category;
        int rootCategoryCount;
        HttpServletRequest request = context.getRequest();
        SearchAdsForm form = (SearchAdsForm)((Object)context.getForm());
        RequestHelper.storeEnum(request, Ad.TradeType.class, "tradeTypes");
        request.setAttribute("lastAdsForTradeType", (Object)form.isLastAds());
        if (context.isAdmin()) {
            request.setAttribute("editable", (Object)true);
            RequestHelper.storeEnum(request, Ad.Status.class, "status");
        }
        Ad.TradeType tradeType = CoercionHelper.coerce(Ad.TradeType.class, form.getQuery().get("tradeType"));
        if (this.settingsService.getLocalSettings().isShowCountersInAdCategories()) {
            AdCategoryWithCounterQuery counterQuery = new AdCategoryWithCounterQuery();
            counterQuery.setTradeType(tradeType);
            List<AdCategoryWithCounterVO> categories = this.adService.getCategoriesWithCounters(counterQuery);
            rootCategoryCount = categories.size();
            request.setAttribute("categories", categories);
            request.setAttribute("showCounters", (Object)true);
        } else {
            List<AdCategory> categories = this.adCategoryService.listRoot();
            rootCategoryCount = categories.size();
            request.setAttribute("categories", categories);
        }
        request.setAttribute("splitCategoriesAt", (Object)(rootCategoryCount / 2));
        if (form.isLastAds() || form.isCategoryOnly()) {
            AdQuery adQuery = new AdQuery();
            adQuery.setStatus(Ad.Status.ACTIVE);
            adQuery.setTradeType(tradeType);
            adQuery.fetch(RelationshipHelper.nested(Ad.Relationships.OWNER, Element.Relationships.USER), Ad.Relationships.CURRENCY, Ad.Relationships.IMAGES);
            form.clearForm();
            form.setQuery("tradeType", tradeType.name());
            return adQuery;
        }
        AbstractAdQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(RelationshipHelper.nested(Ad.Relationships.OWNER, Element.Relationships.USER), Ad.Relationships.CURRENCY, Ad.Relationships.IMAGES, Ad.Relationships.CUSTOM_VALUES, RelationshipHelper.nested(Ad.Relationships.CATEGORY, RelationshipHelper.nested(3, (Relationship)AdCategory.Relationships.PARENT)));
        if (!context.isAdmin()) {
            query.setStatus(Ad.Status.ACTIVE);
        }
        AdCategory adCategory = category = query.getCategory() == null ? null : this.adCategoryService.load(query.getCategory().getId(), RelationshipHelper.nested(3, (Relationship)AdCategory.Relationships.PARENT));
        if (category != null) {
            request.setAttribute("categoryPath", category.getPathFromRoot());
            request.setAttribute("category", (Object)category);
        }
        if (form.isAdvanced()) {
            List<Currency> currencies;
            List<MemberCustomField> memberFields = this.customFieldHelper.onlyForAdSearch(this.memberCustomFieldService.list());
            List<AdCustomField> allAdFields = this.adCustomFieldService.list();
            List<AdCustomField> adFields = this.customFieldHelper.onlyForAdsSearch(this.customFieldHelper.adFieldsForSearch(allAdFields));
            request.setAttribute("memberFields", this.customFieldHelper.buildEntries(memberFields, query.getMemberValues()));
            request.setAttribute("adFields", this.customFieldHelper.buildEntries(adFields, query.getAdValues()));
            GroupFilterQuery groupFilterQuery = new GroupFilterQuery();
            if (context.isAdmin()) {
                AdminGroup adminGroup = (AdminGroup)context.getGroup();
                Collection<MemberGroup> memberGroups = (adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS)).getManagesGroups();
                if (CollectionUtils.isNotEmpty(memberGroups)) {
                    request.setAttribute("memberGroups", memberGroups);
                }
                groupFilterQuery.setAdminGroup(adminGroup);
            } else {
                MemberGroup memberGroup = (MemberGroup)context.getMember().getGroup();
                memberGroup = (MemberGroup)this.groupService.load(memberGroup.getId(), MemberGroup.Relationships.CAN_VIEW_ADS_OF_GROUPS);
                groupFilterQuery.setViewableBy(memberGroup);
            }
            List<GroupFilter> groupFilters = this.groupFilterService.search(groupFilterQuery);
            request.setAttribute("groupFilters", groupFilters);
            request.setAttribute("sincePeriods", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS));
            if (context.isAdmin()) {
                currencies = this.currencyService.listAll();
            } else {
                Member member = (Member)context.getAccountOwner();
                currencies = this.currencyService.listByMemberGroup(member.getMemberGroup());
            }
            if (currencies.size() > 1) {
                request.setAttribute("currencies", currencies);
            }
        }
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        SearchAdsForm form = (SearchAdsForm)((Object)context.getForm());
        if (form.isCategoryOnly()) {
            return false;
        }
        return form.isAlreadySearched() || form.isLastAds() || super.willExecuteQuery(context, queryParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBinder<FullTextAdQuery> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings settings = this.settingsService.getLocalSettings();
                this.dataBinder = SearchAdsAction.adFullTextQueryDataBinder(settings);
            }
            DataBinder<FullTextAdQuery> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

