/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.BaseQueryForm;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.utils.Navigation;
import nl.strohalm.cyclos.utils.binding.MapBean;
import org.apache.struts.action.ActionMapping;

public class SearchAdsForm
extends BaseQueryForm {
    private static final long serialVersionUID = -5275865610699846428L;
    private boolean advanced;
    private boolean forceShowFields;
    private boolean categoryOnly;
    private boolean lastAds;
    private boolean alreadySearched;

    public SearchAdsForm() {
        this.clearForm();
    }

    public void clearForm() {
        this.getQuery().clear();
        this.setQuery("since", new MapBean("number", "period"));
        this.setQuery("adValues", new MapBean(true, "field", "value"));
        this.setQuery("memberValues", new MapBean(true, "field", "value"));
        this.setQuery("tradeType", Ad.TradeType.OFFER.name());
        this.setQuery("status", Ad.Status.ACTIVE.name());
        this.setQuery("groups", Collections.emptyList());
        this.setQuery("groupFilters", Collections.emptyList());
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public boolean isAlreadySearched() {
        return this.alreadySearched;
    }

    public boolean isCategoryOnly() {
        return this.categoryOnly;
    }

    public boolean isForceShowFields() {
        return this.forceShowFields;
    }

    public boolean isLastAds() {
        return this.lastAds;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        Navigation navigation;
        super.reset(mapping, request);
        this.advanced = false;
        this.setQuery("withImagesOnly", "false");
        this.setCategoryOnly(false);
        this.setLastAds(false);
        this.setForceShowFields(false);
        this.setAdvanced(false);
        if (request != null && ((navigation = Navigation.get(request.getSession())) == null || navigation.size() == 1)) {
            this.setQuery("groupFilters", Collections.emptyList());
        }
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public void setAlreadySearched(boolean alreadySearched) {
        this.alreadySearched = alreadySearched;
    }

    public void setCategoryOnly(boolean categoryOnly) {
        this.categoryOnly = categoryOnly;
    }

    public void setForceShowFields(boolean forceShowFields) {
        this.forceShowFields = forceShowFields;
    }

    public void setLastAds(boolean lastAds) {
        this.lastAds = lastAds;
    }
}

