/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads.categories;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.ads.categories.AdCategoryForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.services.ads.AdCategoryService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class EditAdCategoryAction
extends BaseFormAction {
    private AdCategoryService adCategoryService;
    private DataBinder<AdCategory> dataBinder;

    public AdCategoryService getAdCategoryService() {
        return this.adCategoryService;
    }

    public DataBinder<AdCategory> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<AdCategory> binder = BeanBinder.instance(AdCategory.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("parent", PropertyBinder.instance(AdCategory.class, "parent", ReferenceConverter.instance(AdCategory.class)));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("active", PropertyBinder.instance(Boolean.TYPE, "active"));
            binder.registerBinder("order", PropertyBinder.instance(Integer.class, "order"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setAdCategoryService(AdCategoryService adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        AdCategoryForm form = (AdCategoryForm)((Object)context.getForm());
        AdCategory category = this.getDataBinder().readFromString(form.getCategory());
        boolean insert = category.getId() == null;
        long id = 0L;
        if (insert) {
            String[] names = category.getName().split("\\n");
            int count = names.length;
            int nextOrder = -1;
            for (String name : names) {
                if ((name = StringUtils.trimToNull((String)name)) == null) continue;
                AdCategory cat = (AdCategory)category.clone();
                cat.setName(name);
                if (nextOrder >= 0) {
                    cat.setOrder(++nextOrder);
                }
                cat = this.adCategoryService.save(cat);
                if (nextOrder < 0) {
                    nextOrder = cat.getOrder();
                }
                if (count != 1) continue;
                id = cat.getId();
            }
            if (count > 1 && category.getParent() != null) {
                id = category.getParent().getId();
            }
        } else {
            id = this.adCategoryService.save(category).getId();
        }
        context.sendMessage(insert ? "adCategory.inserted" : "adCategory.modified", new Object[0]);
        if (id > 0L) {
            return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "id", id);
        }
        return context.findForward("list");
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        AdCategory category;
        boolean isInsert;
        AdCategoryForm form = (AdCategoryForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        long parentId = form.getParent();
        AdCategory parent = null;
        if (parentId > 0L) {
            parent = this.adCategoryService.load(parentId, RelationshipHelper.nested(3, (Relationship)AdCategory.Relationships.PARENT));
        }
        int level = 0;
        boolean bl = isInsert = form.getId() <= 0L;
        if (!isInsert) {
            category = this.adCategoryService.load(form.getId(), RelationshipHelper.nested(3, (Relationship)AdCategory.Relationships.PARENT), AdCategory.Relationships.CHILDREN);
            request.setAttribute("categoryPath", category.getPathFromRoot());
            request.setAttribute("categories", category.getChildren());
            level = category.getLevel();
        } else {
            category = new AdCategory();
            category.setParent(parent);
            category.setActive(true);
            int n = level = parent == null ? 1 : parent.getLevel() + 1;
            if (parent != null) {
                request.setAttribute("categoryPath", parent.getPathFromRoot());
            }
        }
        boolean isMaxLevel = level >= 3;
        this.getDataBinder().writeAsString(form.getCategory(), category);
        request.setAttribute("category", (Object)category);
        request.setAttribute("editable", (Object)this.permissionService.hasPermission(AdminSystemPermission.AD_CATEGORIES_MANAGE));
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("isMaxLevel", (Object)isMaxLevel);
    }

    @Override
    protected void validateForm(ActionContext context) {
        AdCategoryForm form = (AdCategoryForm)((Object)context.getForm());
        AdCategory category = this.getDataBinder().readFromString(form.getCategory());
        this.adCategoryService.validate(category);
    }
}

