/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads.categories;

import java.io.InputStream;
import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.ads.categories.ImportAdCategoriesForm;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.ads.AdCategoryService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class ImportAdCategoriesAction
extends BaseAction {
    private AdCategoryService adCategoryService;

    @Inject
    public void setAdCategoryService(AdCategoryService adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        ImportAdCategoriesForm form = (ImportAdCategoriesForm)((Object)context.getForm());
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        FormFile upload = form.getUpload();
        try {
            List lines = IOUtils.readLines((InputStream)upload.getInputStream(), (String)localSettings.getCharset());
            String xml = StringUtils.join(lines.iterator(), (char)'\n');
            this.adCategoryService.importFromXml(xml);
            context.sendMessage("adCategory.imported", new Object[0]);
        }
        catch (PermissionDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            context.sendMessage("adCategory.error.importing", new Object[0]);
        }
        finally {
            upload.destroy();
        }
        return context.getSuccessForward();
    }
}

