/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads.categories;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.ads.categories.AdCategoryForm;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.services.ads.AdCategoryService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class RemoveAdCategoryAction
extends BaseAction {
    private AdCategoryService adCategoryService;

    public AdCategoryService getAdCategoryService() {
        return this.adCategoryService;
    }

    @Inject
    public void setAdCategoryService(AdCategoryService adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        AdCategoryForm form = (AdCategoryForm)((Object)context.getForm());
        if (form.getId() <= 0L) {
            throw new ValidationException();
        }
        try {
            AdCategory adCategory = this.adCategoryService.load(form.getId(), AdCategory.Relationships.PARENT);
            AdCategory parent = adCategory.getParent();
            this.adCategoryService.remove(form.getId());
            context.sendMessage("adCategory.removed", new Object[0]);
            if (parent != null) {
                return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "id", parent.getId());
            }
            return context.findForward("list");
        }
        catch (DaoException e) {
            return context.sendError("adCategory.error.removing", new Object[0]);
        }
    }
}

