/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads.categories;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.ads.categories.SetAdCategoryOrderForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.AdCategoryQuery;
import nl.strohalm.cyclos.services.ads.AdCategoryService;
import nl.strohalm.cyclos.utils.ActionHelper;
import org.apache.struts.action.ActionForward;

public class SetAdCategoryOrderAction
extends BaseFormAction {
    private AdCategoryService adCategoryService;

    public AdCategoryService getAdCategoryService() {
        return this.adCategoryService;
    }

    @Inject
    public void setAdCategoryService(AdCategoryService adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        SetAdCategoryOrderForm form = (SetAdCategoryOrderForm)((Object)context.getForm());
        this.adCategoryService.setOrder(form.getAdCategoryIds());
        context.sendMessage("adCategory.orderModified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "currentCategory", form.getCurrentCategory());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        SetAdCategoryOrderForm form = (SetAdCategoryOrderForm)((Object)context.getForm());
        List<AdCategory> categories = null;
        AdCategoryQuery query = new AdCategoryQuery();
        long currentId = form.getCurrentCategory();
        AdCategory adCategory = null;
        if (currentId > 0L) {
            adCategory = this.adCategoryService.load(currentId, new Relationship[0]);
            query.setParent(adCategory);
        }
        query.setReturnDisabled(true);
        query.setOrderAlphabetically(form.isOrderAlpha());
        categories = this.adCategoryService.search(query);
        request.setAttribute("adCategories", categories);
        request.setAttribute("currentCategory", (Object)adCategory);
    }
}

