/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads.imports;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.ads.imports.ImportAdsForm;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.ads.imports.AdImport;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.ads.AdImportService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.csv.UnknownColumnException;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class ImportAdsAction
extends BaseFormAction {
    private AdImportService adImportService;
    private CurrencyService currencyService;
    private DataBinder<AdImport> dataBinder;

    public DataBinder<AdImport> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<AdImport> binder = BeanBinder.instance(AdImport.class);
            binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setAdImportService(AdImportService adImportService) {
        this.adImportService = adImportService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ImportAdsForm form = (ImportAdsForm)((Object)context.getForm());
        FormFile upload = form.getUpload();
        if (upload == null || upload.getFileSize() == 0) {
            throw new ValidationException("upload", "adImport.file", new RequiredError(new Object[0]));
        }
        AdImport adImport = this.getDataBinder().readFromString(form.getImport());
        try {
            adImport = this.adImportService.importAds(adImport, upload.getInputStream());
            ActionForward actionForward = ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "importId", adImport.getId());
            return actionForward;
        }
        catch (UnknownColumnException e) {
            ActionForward actionForward = context.sendError("general.error.csv.unknownColumn", e.getColumn());
            return actionForward;
        }
        finally {
            upload.destroy();
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        List<Currency> currencies = this.currencyService.listAll();
        if (currencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)currencies.get(0));
        }
        request.setAttribute("currencies", currencies);
    }

    @Override
    protected void validateForm(ActionContext context) {
        ImportAdsForm form = (ImportAdsForm)((Object)context.getForm());
        AdImport adImport = this.getDataBinder().readFromString(form.getImport());
        this.adImportService.validate(adImport);
    }
}

