/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads.imports;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.ads.imports.ImportedAdsDetailsForm;
import nl.strohalm.cyclos.entities.ads.imports.AdImport;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAd;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAdQuery;
import nl.strohalm.cyclos.services.ads.AdImportService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ImportedAdsDetailsAction
extends BaseQueryAction {
    private AdImportService adImportService;
    private DataBinder<ImportedAdQuery> dataBinder;

    public DataBinder<ImportedAdQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ImportedAdQuery> binder = BeanBinder.instance(ImportedAdQuery.class);
            binder.registerBinder("adImport", PropertyBinder.instance(AdImport.class, "adImport"));
            binder.registerBinder("status", PropertyBinder.instance(ImportedAdQuery.Status.class, "status"));
            binder.registerBinder("lineNumber", PropertyBinder.instance(Integer.class, "lineNumber"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            return binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setAdImportService(AdImportService adImportService) {
        this.adImportService = adImportService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        ImportedAdQuery query = (ImportedAdQuery)queryParameters;
        List<ImportedAd> ads = this.adImportService.searchImportedAds(query);
        request.setAttribute("importedAds", ads);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        ImportedAdsDetailsForm form = (ImportedAdsDetailsForm)((Object)context.getForm());
        ImportedAdQuery query = this.getDataBinder().readFromString(form.getQuery());
        AdImport adImport = this.adImportService.load(query.getAdImport().getId(), AdImport.Relationships.CURRENCY);
        if (adImport == null || query.getStatus() == null) {
            throw new ValidationException();
        }
        query.setAdImport(adImport);
        request.setAttribute("lowercaseStatus", (Object)query.getStatus().name().toLowerCase());
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

