/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.ads.imports;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.ads.imports.ImportedAdsSummaryForm;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.ads.imports.AdImport;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.ads.AdImportService;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ImportedAdsSummaryAction
extends BaseFormAction {
    private AdImportService adImportService;
    private CurrencyService currencyService;

    @Inject
    public void setAdImportService(AdImportService adImportService) {
        this.adImportService = adImportService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        AdImport adImport = this.getImport(context);
        this.adImportService.processImport(adImport);
        context.sendMessage("adImport.processed", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        AdImport adImport = this.getImport(context);
        HttpServletRequest request = context.getRequest();
        request.setAttribute("adImport", (Object)adImport);
        request.setAttribute("summary", (Object)this.adImportService.getSummary(adImport));
        List<Currency> currencies = this.currencyService.listAll();
        if (currencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)currencies.get(0));
        }
    }

    private AdImport getImport(ActionContext context) {
        ImportedAdsSummaryForm form = (ImportedAdsSummaryForm)((Object)context.getForm());
        try {
            return this.adImportService.load(form.getImportId(), AdImport.Relationships.CURRENCY);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
    }
}

