/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.alerts;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.entities.alerts.Alert;
import nl.strohalm.cyclos.entities.alerts.AlertQuery;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.services.alerts.AlertService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.struts.action.ActionForward;

public abstract class BaseListAlertsAction
extends BaseAction {
    private static final int MAX_ALERTS = 200;
    private AlertService alertService;

    public AlertService getAlertService() {
        return this.alertService;
    }

    @Inject
    public void setAlertService(AlertService alertService) {
        this.alertService = alertService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        AlertQuery query = new AlertQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setPageParameters(PageParameters.max(200));
        query.setShowRemoved(false);
        Alert.Type type = this.getType();
        query.setType(type);
        if (Alert.Type.MEMBER.equals((Object)type) && context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
            query.setGroups(adminGroup.getManagesGroups());
            query.fetch(RelationshipHelper.nested(MemberAlert.Relationships.MEMBER, Element.Relationships.USER));
        }
        List<? extends Alert> alerts = this.alertService.search(query);
        request.setAttribute("alerts", alerts);
        request.setAttribute("isSystem", (Object)(type == Alert.Type.SYSTEM ? 1 : 0));
        request.setAttribute("isMember", (Object)(type == Alert.Type.MEMBER ? 1 : 0));
        return context.getInputForward();
    }

    protected abstract Alert.Type getType();
}

