/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.alerts;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.alerts.SearchAlertsForm;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.entities.alerts.Alert;
import nl.strohalm.cyclos.entities.alerts.AlertQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.alerts.AlertService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchAlertsAction
extends BaseQueryAction {
    private DataBinder<AlertQuery> dataBinder;
    private AlertService alertService;

    public AlertService getAlertService() {
        return this.alertService;
    }

    public DataBinder<AlertQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<AlertQuery> binder = BeanBinder.instance(AlertQuery.class);
            binder.registerBinder("type", PropertyBinder.instance(Alert.Type.class, "type"));
            binder.registerBinder("period", DataBinderHelper.periodBinder(localSettings, "period"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member", ReferenceConverter.instance(Member.class)));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setAlertService(AlertService alertService) {
        this.alertService = alertService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        AlertQuery query = (AlertQuery)queryParameters;
        List<? extends Alert> alerts = this.alertService.search(query);
        context.getRequest().setAttribute("alerts", alerts);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchAlertsForm form = (SearchAlertsForm)((Object)context.getForm());
        AlertQuery query = this.getDataBinder().readFromString(form.getQuery());
        if (query.getMember() instanceof EntityReference) {
            query.setMember((Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER));
        }
        if (context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
            query.setGroups(adminGroup.getManagesGroups());
        }
        query.setShowRemoved(true);
        ArrayList<Alert.Type> types = new ArrayList<Alert.Type>();
        if (this.permissionService.hasPermission(AdminSystemPermission.ALERTS_VIEW_SYSTEM_ALERTS)) {
            types.add(Alert.Type.SYSTEM);
        }
        if (this.permissionService.hasPermission(AdminSystemPermission.ALERTS_VIEW_MEMBER_ALERTS)) {
            types.add(Alert.Type.MEMBER);
        }
        request.setAttribute("types", types);
        request.setAttribute("isMember", (Object)(query.getType() == Alert.Type.MEMBER && query.getMember() == null ? 1 : 0));
        return query;
    }
}

