/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.alerts;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.alerts.ViewErrorLogEntryForm;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.alerts.ErrorLogEntry;
import nl.strohalm.cyclos.services.alerts.ErrorLogService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ViewErrorLogEntryAction
extends BaseAction {
    private ErrorLogService errorLogService;

    @Inject
    public void setErrorLogService(ErrorLogService errorLogService) {
        this.errorLogService = errorLogService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        ViewErrorLogEntryForm form = (ViewErrorLogEntryForm)((Object)context.getForm());
        long id = form.getEntryId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        HttpServletRequest request = context.getRequest();
        ErrorLogEntry entry = this.errorLogService.load(id, ErrorLogEntry.Relationships.PARAMETERS, RelationshipHelper.nested(ErrorLogEntry.Relationships.LOGGED_USER, User.Relationships.ELEMENT));
        User loggedUser = entry.getLoggedUser();
        if (loggedUser instanceof MemberUser) {
            request.setAttribute("loggedMember", (Object)loggedUser.getElement());
        } else if (loggedUser instanceof AdminUser) {
            request.setAttribute("loggedAdmin", (Object)loggedUser.getElement());
        }
        request.setAttribute("errorLogEntry", (Object)entry);
        return context.getInputForward();
    }
}

