/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.channels;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.channels.EditChannelForm;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class EditChannelAction
extends BaseFormAction {
    private ChannelService channelService;
    private DataBinder<Channel> dataBinder;

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        Channel channel = this.resolveChannel(context);
        boolean isInsert = channel.isTransient();
        channel = this.channelService.save(channel);
        if (isInsert) {
            context.sendMessage("channel.inserted", new Object[0]);
        } else {
            context.sendMessage("channel.modified", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "channelId", channel.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean allowsPaymentRequest;
        boolean isBuiltin;
        Channel channel;
        HttpServletRequest request = context.getRequest();
        EditChannelForm form = (EditChannelForm)((Object)context.getForm());
        long id = form.getChannelId();
        if (id <= 0L) {
            channel = new Channel();
            isBuiltin = false;
            allowsPaymentRequest = true;
        } else {
            channel = this.channelService.load(id);
            String internalName = channel.getInternalName();
            isBuiltin = this.channelService.isBuiltin(internalName);
            allowsPaymentRequest = this.channelService.allowsPaymentRequest(internalName);
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        LinkedHashMap<PrincipalType, String> possiblePrincipalTypes = new LinkedHashMap<PrincipalType, String>();
        List<MemberCustomField> customFields = this.channelService.possibleCustomFieldsAsPrincipal();
        for (Channel.Principal principal : Channel.Principal.values()) {
            if (principal == Channel.Principal.CUSTOM_FIELD) {
                for (MemberCustomField customField : customFields) {
                    possiblePrincipalTypes.put(new PrincipalType(customField), customField.getName());
                }
                continue;
            }
            if (principal == Channel.Principal.EMAIL && !localSettings.isEmailUnique()) continue;
            String label = context.message(principal.getKey(), new Object[0]);
            possiblePrincipalTypes.put(new PrincipalType(principal), label);
        }
        Set<Channel.Credentials> possibleCredentials = this.channelService.getPossibleCredentials(channel);
        this.getDataBinder().writeAsString(form.getChannel(), channel);
        request.setAttribute("channel", (Object)channel);
        request.setAttribute("isBuiltin", (Object)isBuiltin);
        request.setAttribute("possiblePrincipalTypes", possiblePrincipalTypes);
        request.setAttribute("possibleCredentials", possibleCredentials);
        request.setAttribute("singleCredential", possibleCredentials.size() == 1 ? possibleCredentials.iterator().next() : null);
        request.setAttribute("allowsPaymentRequest", (Object)allowsPaymentRequest);
        request.setAttribute("canManage", (Object)this.permissionService.hasPermission(AdminSystemPermission.CHANNELS_MANAGE));
    }

    @Override
    protected void validateForm(ActionContext context) {
        Channel channel = this.resolveChannel(context);
        this.channelService.validate(channel);
    }

    private DataBinder<Channel> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<Channel> binder = BeanBinder.instance(Channel.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("internalName", PropertyBinder.instance(String.class, "internalName"));
            binder.registerBinder("displayName", PropertyBinder.instance(String.class, "displayName"));
            binder.registerBinder("credentials", PropertyBinder.instance(Channel.Credentials.class, "credentials"));
            binder.registerBinder("paymentRequestWebServiceUrl", PropertyBinder.instance(String.class, "paymentRequestWebServiceUrl"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    private Channel resolveChannel(ActionContext context) {
        EditChannelForm form = (EditChannelForm)((Object)context.getForm());
        Channel channel = this.getDataBinder().readFromString(form.getChannel());
        if (form.getPrincipalTypes() != null) {
            try {
                PrincipalType defaultPrincipalType = this.channelService.resolvePrincipalType(form.getDefaultPrincipalType());
                HashSet<PrincipalType> principalTypes = new HashSet<PrincipalType>();
                if (form.getPrincipalTypes() != null) {
                    for (String principalTypeString : form.getPrincipalTypes()) {
                        if (!StringUtils.isNotEmpty((String)principalTypeString)) continue;
                        principalTypes.add(this.channelService.resolvePrincipalType(principalTypeString));
                    }
                }
                channel.setPrincipalTypes(principalTypes, defaultPrincipalType);
            }
            catch (Exception e) {
                throw new ValidationException();
            }
        }
        return channel;
    }
}

