/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.documents;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.documents.EditDynamicDocumentForm;
import nl.strohalm.cyclos.entities.customization.documents.DocumentPage;
import nl.strohalm.cyclos.entities.customization.documents.DynamicDocument;
import nl.strohalm.cyclos.services.customization.DocumentService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class EditDynamicDocumentAction
extends BaseFormAction {
    private DocumentService documentService;
    private DataBinder<DynamicDocument> dataBinder;
    private CustomizationHelper customizationHelper;

    public DataBinder<DynamicDocument> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<DocumentPage> formPageBinder = BeanBinder.instance(DocumentPage.class, "formPage");
            formPageBinder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            formPageBinder.registerBinder("contents", PropertyBinder.instance(String.class, "contents", CoercionConverter.instance(String.class)));
            BeanBinder<DocumentPage> documentPageBinder = BeanBinder.instance(DocumentPage.class, "documentPage");
            documentPageBinder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            documentPageBinder.registerBinder("contents", PropertyBinder.instance(String.class, "contents", CoercionConverter.instance(String.class)));
            BeanBinder<DynamicDocument> binder = BeanBinder.instance(DynamicDocument.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("formPage", formPageBinder);
            binder.registerBinder("documentPage", documentPageBinder);
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditDynamicDocumentForm form = (EditDynamicDocumentForm)((Object)context.getForm());
        DynamicDocument document = this.getDataBinder().readFromString(form.getDocument());
        boolean isInsert = document.getId() == null;
        if ((document = (DynamicDocument)this.documentService.saveDynamic(document)).isHasFormPage()) {
            File formFile = this.customizationHelper.formFile(document);
            this.customizationHelper.updateFile(formFile, document.getFormPage());
        }
        File documentFile = this.customizationHelper.documentFile(document);
        this.customizationHelper.updateFile(documentFile, document.getDocumentPage());
        context.sendMessage(isInsert ? "document.inserted" : "document.modified", new Object[0]);
        return ActionHelper.redirectWithParam(request, context.getSuccessForward(), "documentId", document.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditDynamicDocumentForm form = (EditDynamicDocumentForm)((Object)context.getForm());
        long id = form.getDocumentId();
        DynamicDocument document = id > 0L ? (DynamicDocument)this.documentService.load(id, DynamicDocument.Relationships.FORM_PAGE, DynamicDocument.Relationships.DOCUMENT_PAGE) : new DynamicDocument();
        this.getDataBinder().writeAsString(form.getDocument(), document);
        request.setAttribute("document", (Object)document);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditDynamicDocumentForm form = (EditDynamicDocumentForm)((Object)context.getForm());
        DynamicDocument document = this.retrieveDocument(form);
        this.documentService.validate(document, false);
    }

    private DynamicDocument retrieveDocument(EditDynamicDocumentForm form) {
        DynamicDocument document = this.getDataBinder().readFromString(form.getDocument());
        DocumentPage formPage = document.getFormPage();
        if (formPage == null || StringUtils.isEmpty((String)formPage.getContents())) {
            document.setFormPage(null);
        } else {
            File formFile = this.customizationHelper.formFile(document);
            formPage.setName(formFile.getName());
        }
        DocumentPage documentPage = document.getDocumentPage();
        if (documentPage == null || StringUtils.isEmpty((String)documentPage.getContents())) {
            document.setDocumentPage(null);
        } else {
            File documentFile = this.customizationHelper.documentFile(document);
            documentPage.setName(documentFile.getName());
        }
        return document;
    }
}

