/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.documents;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.customization.documents.EditMemberDocumentForm;
import nl.strohalm.cyclos.controls.customization.documents.EditStaticDocumentAction;
import nl.strohalm.cyclos.controls.customization.documents.EditStaticDocumentForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.MemberDocument;
import nl.strohalm.cyclos.entities.customization.documents.StaticDocument;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.exceptions.CannotUploadFileException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class EditMemberDocumentAction
extends EditStaticDocumentAction {
    private DataBinder<MemberDocument> dataBinder;

    @Override
    protected Class<? extends StaticDocument> getEntityType() {
        return MemberDocument.class;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditStaticDocumentForm form = (EditStaticDocumentForm)((Object)context.getForm());
        MemberDocument document = this.getDataBinder().readFromString(form.getDocument());
        boolean isInsert = document.getId() == null;
        try {
            FormFile upload = form.getUpload();
            document = (MemberDocument)this.documentService.saveStatic(document, upload.getInputStream(), upload.getFileSize(), upload.getFileName(), upload.getContentType());
            context.sendMessage(isInsert ? "document.inserted" : "document.modified", new Object[0]);
            request.setAttribute("document", (Object)document);
            return ActionHelper.redirectWithParam(request, context.getSuccessForward(), "documentId", document.getId());
        }
        catch (IOException e) {
            throw new CannotUploadFileException(e);
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        Member member;
        MemberDocument document;
        HttpServletRequest request = context.getRequest();
        EditMemberDocumentForm form = (EditMemberDocumentForm)((Object)context.getForm());
        long documentId = form.getDocumentId();
        if (documentId > 0L) {
            document = (MemberDocument)this.documentService.load(documentId, new Relationship[0]);
            member = document.getMember();
        } else {
            long memberId = form.getMemberId();
            if (memberId < 1L) {
                throw new ValidationException();
            }
            member = EntityHelper.reference(Member.class, memberId);
            document = new MemberDocument();
            document.setMember(member);
        }
        boolean byBroker = context.isBrokerOf(member) && this.permissionService.hasPermission(BrokerPermission.DOCUMENTS_MANAGE_MEMBER);
        boolean adminCanManage = context.isAdmin() && this.permissionService.hasPermission(AdminMemberPermission.DOCUMENTS_MANAGE_MEMBER);
        this.getDataBinder().writeAsString(form.getDocument(), document);
        request.setAttribute("member", (Object)member);
        request.setAttribute("document", (Object)document);
        request.setAttribute("byBroker", (Object)byBroker);
        request.setAttribute("adminCanManage", (Object)adminCanManage);
        ArrayList<MemberDocument.Visibility> visibilities = new ArrayList<MemberDocument.Visibility>();
        visibilities.add(MemberDocument.Visibility.BROKER);
        visibilities.add(MemberDocument.Visibility.MEMBER);
        if (!byBroker) {
            visibilities.add(MemberDocument.Visibility.ADMIN);
        }
        request.setAttribute("visibilities", visibilities);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditStaticDocumentForm form = (EditStaticDocumentForm)((Object)context.getForm());
        Document document = this.getDataBinder().readFromString(form.getDocument());
        this.documentService.validate(document, false);
    }

    private DataBinder<MemberDocument> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MemberDocument> beanBinder = EditStaticDocumentAction.getDataBinder(MemberDocument.class);
            beanBinder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            beanBinder.registerBinder("visibility", PropertyBinder.instance(MemberDocument.Visibility.class, "visibility"));
            this.dataBinder = beanBinder;
        }
        return this.dataBinder;
    }
}

