/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.documents;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.documents.EditStaticDocumentForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.StaticDocument;
import nl.strohalm.cyclos.services.customization.DocumentService;
import nl.strohalm.cyclos.services.customization.exceptions.CannotUploadFileException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class EditStaticDocumentAction
extends BaseFormAction {
    protected DocumentService documentService;
    private DataBinder<StaticDocument> dataBinder;

    public static <T extends StaticDocument> BeanBinder<T> getDataBinder(Class<T> type) {
        BeanBinder<T> binder = BeanBinder.instance(type);
        binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
        return binder;
    }

    @Inject
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected Class<? extends StaticDocument> getEntityType() {
        return StaticDocument.class;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditStaticDocumentForm form = (EditStaticDocumentForm)((Object)context.getForm());
        StaticDocument document = this.getDataBinder().readFromString(form.getDocument());
        boolean isInsert = document.getId() == null;
        try {
            FormFile upload = form.getUpload();
            document = (StaticDocument)this.documentService.saveStatic(document, upload.getInputStream(), upload.getFileSize(), upload.getFileName(), upload.getContentType());
            context.sendMessage(isInsert ? "document.inserted" : "document.modified", new Object[0]);
            request.setAttribute("document", (Object)document);
            return ActionHelper.redirectWithParam(request, context.getSuccessForward(), "documentId", document.getId());
        }
        catch (IOException e) {
            throw new CannotUploadFileException(e);
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditStaticDocumentForm form = (EditStaticDocumentForm)((Object)context.getForm());
        long id = form.getDocumentId();
        StaticDocument document = id > 0L ? (StaticDocument)this.documentService.load(id, new Relationship[0]) : ClassHelper.instantiate(this.getEntityType());
        this.getDataBinder().writeAsString(form.getDocument(), document);
        request.setAttribute("document", (Object)document);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditStaticDocumentForm form = (EditStaticDocumentForm)((Object)context.getForm());
        Document document = this.getDataBinder().readFromString(form.getDocument());
        this.documentService.validate(document, false);
    }

    private DataBinder<StaticDocument> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = EditStaticDocumentAction.getDataBinder(StaticDocument.class);
        }
        return this.dataBinder;
    }
}

